// Mikropuhe 4.2 SAPI 32-bittinen vanhempien versioiden kanssa yhteensopiva DLL (mpwinnt.dll)
// Muutoksia vanhaan ovat:
// - Jokainen puhuva ohjelma saa omakseen tyden syntetisaattorin, en ei ole yht jaettua syntetisaattoria.
//
// WINAPI on mritetty windef.h:ssa seuraavasti:
// #define WINAPI      __stdcall

// Functions defined in mpwinnt.dll. Please note that:
// - Every speaking application (process) gets its own full synthesizer, there is not one shared synthesizer.

// TAB = 3 spaces


#ifndef _MPWINNT_H
#define _MPWINNT_H

#ifdef __cplusplus
extern "C" {
#endif

#ifdef PROTOTYYPIT_TARVITAAN

/****************************************************************************
*                                                                           *
*  Prototyyppej ei tarvita ellei kytet 'import library' - liitnttapaa  *
*	Prototypes are not needed unless static linkage with import library is   *
*  used. Define PROTOTYYPIT_TARVITAAN before including this file if you     *
*  want to use static linking to mpwinnt.dll.                               *
*                                                                           *
****************************************************************************/

#ifdef _MSC_VER
	#ifndef MPWINNT_FUNCTYPE
		// MSVC-erikoisuus export-funktioille. Tll on merkityst jos kytetn import-librarya
		// Stuff for Microsoft C compiler
		#define MPWINNT_FUNCTYPE    __declspec( dllimport )
	#endif
#else
	#define MPWINNT_FUNCTYPE
#endif


// Do not specify if you are going to use only MPWIN_SpeakFile32/MPWIN_PuhuTiedostoon32 function.
// If specified, computer MUST have working 16 bits audio card.
// Default=specified
#define MPWIN_INITPRE_USESOUNDCARD		1

// Instructs DLL not to create main synthesizer module used for MPWIN_SpeakEx-call and enables only calling function MPWIN_SpeakFile32/MPWIN_PuhuTiedostoon32
// You may call any functions but only MPWIN_SpeakFile32 will work
// Default=Not specified
#define MPWIN_INITPRE_ONLYTOFILE			2

// If specified, this library will not call CoInitialize and CoUninitialize.
// Default=Not specified
#define MPWIN_INITPRE_NOCOINITIALIZE	4

/*	
*	Call before calling MPWIN_Initialize/MPWIN_Alusta if you want to change general function of the DLL.
*
*	Function is exported with name _MPWIN_PreInitialize@4
*
*	Parametrit/parameters:
*
*	dwFlags	-> Combination of MPWIN_INITPRE_xxx
*
*	Palaute / Returns:  Previous value
*/
MPWINNT_FUNCTYPE DWORD WINAPI MPWIN_PreInitialize( DWORD dwFlags );


/*	
*	Alustaa puhesyntetisaattorin, pit kutsua ennen kuin kutsutaan mitn
*	muuta puhesyntetisaattorin funktiota.
*
*	Initializes the speech synthesizer. Must be called before calling any other function.
*	English name for this function is MPWIN_Initialize.
*
*	Funktion export-nimi on _MPWIN_Alusta@4
*	Function is exported with name _MPWIN_Alusta@4
*
*	Parametrit/parameters:
*
*	hWndParent	-> Omistajaikkuna virheilmoituksia varten / Owner window for possible error message
*
*	Palaute / Returns:  0 = OK
*							 -1 = Vikaa (ilmoitus annettu) / Failed (message already given)
*/
MPWINNT_FUNCTYPE short WINAPI MPWIN_Alusta( HWND hWndParent );

// English name
#define MPWIN_Initialize	MPWIN_Alusta

/*	
*	Panee tekstilohkon puhumisjonoon. Tekstilohko saa olla enintn
*	32 kilotavua pitk. (SAPI-versiolla ei ole en tt rajoitusta)
*
*	Adds text to speech queue. There is no limit for length of the text.
*	English name for this function is MPWIN_Speak.
*
*	Funktion export-nimi on _MPWIN_Puhu@12
*	Function is exported with name _MPWIN_Puhu@12
*
*	Parametrit/parameters:
*
*	lpTxt			-> Puhuttava teksti / Text to be spoken
*	hWndParent	-> Virheilmoitusdialogin omistajaikkuna, ja ikkuna jolle
*						lhetetn tieto, kun teksti on puhuttu (NULL=ei mritetty).
*						Owner of possible error message (mp4sapi will not show any error message).
*						Also window that will receive notification message when text has been spoken.
*						NULL=Not defined or no notification needed
*	wNotifyMsg	-> Mik viesti ikkunalle (jos ei ollut NULL) lhetetn,
*					   kun teksti on puhuttu (0=Ei lhetet viesti).
*						Notification message if hWndParent is not NULL. 0=Notification is not needed.
*
*	Palaute/Returns:	 0 = OK
*							-1 = D/A-muunnoksen kynnistminen eponnistui / Starting D/A failed (not in sapi-version)
*							-2 = Muisti loppui / Out of memory
*							-3 = MPWIN.EXE:n kynnistminen eponnistui / (not in sapi-version)
*/
MPWINNT_FUNCTYPE short WINAPI MPWIN_Puhu( LPCSTR lpTxt, HWND hWndParent, WORD wNotifyMsg );

// English name
#define MPWIN_Speak	MPWIN_Puhu


// Tiedoston puhumista varten varattu / Used in function MPWIN_PuhuTiedostoon32 - generate 16 bits signed signal, otherwise 8 bits unsigned.
#define MPWIN_PUHUEX_16BITSILE	1

// Pst kenoviivoilla alkavat sapi-tagit syntetisaattorille. MPWIN_Puhu muuntaa kaikki kenoviivat
// SAPI-mrityksen mukaisesti tuplakenoviivoiksi, jolloin ne puhutaan yksittisin kenoviivoina.
// Huom! Muunna tekstiss olevat kenoviivat tuplakenoviivoiksi, esimerkiksi:
// "\vce=speaker=Saga\Olen Saga ja tss on tiedoston nimi, c:\\ohjelmat\\tiedosto"
//
// Pass possible sapi control tags to synthesizer. If this is not defined, all backslashes are converted
// to double backslashes according to sapi definition. Note that you must convert all backslashes that are
// not sapi control tags to double backslahses if you use this tag:
// "\vce=speaker=Saga\I am computer and here comes file name, c:\\programs\\file"
#define MPWIN_PUHUEX_SAPITAGS		2

// Normaalisti puhearvot palautetaan oletuksiin joka puhumiskerran vlill. Puhent ei palauteta.
// Tt kytten arvoja ei palauteta.
//
// mpwinnt.dll resets all speech attributes to defaults before speaking text passed to MPWIN_Puhu.
// if you specify this, attributes are preserved between MPWIN_Puhu calls.
#define MPWIN_PUHUEX_NORESET		4

// If you want MPWIN_SpeakToFile32 to dispatch messages when waiting signal to be processed.
// Otherwise thread is totally blocked with WaitForSingeObject-call.
#define MPWIN_PUHUEX_DISPATCHMSG		8


/*	
*	Vastaava kuin MPWIN_Puhu, paitsi lisparametri / Similar to MPWIN_Puhu except one additional parameter
*
*	Funktion export-nimi on _MPWIN_PuhuEx@16
*	Function is exported with name _MPWIN_PuhuEx@16
*
*	Parametrit / Parameters:
*
*	dwFlags	-> MPWIN_PUHUEX_xxx
*
*	Palaute / Retruns: Sama kuin MPWIN_Puhu / Same as MPWIN_Puhu
*/
MPWINNT_FUNCTYPE short WINAPI MPWIN_PuhuEx( LPCSTR lpTxt, HWND hWndParent, WORD wNotifyMsg, DWORD dwFlags );

// English name
#define MPWIN_SpeakEx	MPWIN_PuhuEx

/*	
*	Keskeytt puheen ja poistaa kaikki tekstilohkot.
*	Funktion export-nimi on _MPWIN_Keskeyta@0
*	Palaute: FALSE=Ei ollut puhe menossa, TRUE=Puhe keskeytetty		
*
*	Interrupts speaking and flushes all queued text blocks.
*	English name for this function is MPWIN_Stop.
*	Function is exported with name _MPWIN_Keskeyta@0
*	Returns: FALSE=Synthesizer was not currently speaking, TRUE=Speaking interrupted
*/
MPWINNT_FUNCTYPE BOOL WINAPI MPWIN_Keskeyta( void );

// English name
#define MPWIN_Stop	MPWIN_Keskeyta


/*	
*	Kertoo, onko puhe pll.
*	Funktion export-nimi on _MPWIN_Puhuuko@0
*	Palaute: FALSE=Ei ollut puhe menossa, TRUE=Puhuu
*
*	Tells if synthesizer is speaking.
*	English name for this function is MPWIN_IsSpeaking.
*	Function is exported with name _MPWIN_Puhuuko@0
*	Returns: FALSE=Synthesizer is not currently speaking, TRUE=Speaking
*/
MPWINNT_FUNCTYPE BOOL WINAPI MPWIN_Puhuuko( void );

// English name
#define MPWIN_IsSpeaking	MPWIN_Puhuuko

/*
*	Puhuu tiedoston. Palaa vasta kun tiedosto on valmis. Puhuminen hoidetaan omassa
*	sikeessn, jotta kutsuvan sikeen messagelooppia ei tarvitsisi pyritt,
*	Puhumisen aikana odotellaan tiedoston valmistumista kskyll WaitForSingleObject(hPuhuvaSie).
*
*	Funktion export-nimi on _MPWIN_PuhuTiedostoon32@12
*
*	Parametrit:
*
*	pTxt				-> Puhuttava teksti (ei maksimipituutta), sapi-tageja ei vlitet vaan kenoviivat muutetaan tuplakenoiksi
*	pTiedostoNimi	-> Kohdetiedoston nimi
*	dwTee16Bit		-> Tehdnk 16-bittist signaalia (TRUE) vai 8-bittist (FALSE). Huom! thn voi list MPWIN_PUHUEX_16BITSILE, MPWIN_PUHUEX_SAPITAGS
*
*	Palaute: 0=Ok, -1=Mrittelemtn vika (dialogia ei ole annettu)
*
*
*	Speaksi to file. Returns after file is complete. Synthesizer runs in its own thread and calling
*	thread is blocked until function returns (PeekMessage, GetMessage or similar is not called).
*	Calling thread is blocked with function WaitForSingleObject(hSpeakingThread).
*
*	English name for this function is MPWIN_SpeakFile32.
*	Function is exported with name _MPWIN_PuhuTiedostoon32@12
*
*	Parameters:
*
*	pTxt				-> Text to be spoken
*	pTiedostoNimi	-> Name of destination file
*	dwTee16Bit		-> Combination of MPWIN_PUHUEX_xxx flags. NOTE: MPWIN_PUHUEX_DISPATCHMSG
*
*	Returns: 0=Ok, -1=Unspecified error (no error message has been shown)
*
*/
MPWINNT_FUNCTYPE short WINAPI MPWIN_PuhuTiedostoon32( LPCSTR pTxt, LPCSTR pTiedostoNimi, DWORD dwTee16Bit /*oikeasti dwFlags*/ );

#define MPWIN_SpeakFile32	MPWIN_PuhuTiedostoon32


/*
*	Vapauttaa kaiken paitsi OLE-DLL:t. Tmn jlkeen on kutsuttava MPWIN_Alusta ennen kuin hommat voivat taas jatkua.
*	Funktion export-nimi on _MPWIN_FreeAll@0
*
*	Frees all but OLE DLLs. Call MPWIN_Alusta/MPWIN_Initialize again if you need to speak again.
*	Function is exported with name _MPWIN_FreeAll@0
*/
MPWINNT_FUNCTYPE void WINAPI MPWIN_FreeAll(void);

#endif

#ifdef __cplusplus
}		// extern "C" {
#endif

#endif
