// MikroPuheen sisltmt rajapinnat, MP5

#ifndef _MPCOM_H
#define _MPCOM_H


// Mink registryavaimen alla talletetaan yleisi asetuksia (varsinaiset asetukset pidetn levyll tiedostossa), juurena on HKLM
#define MP_REG_KEYBASE			"Software\\Timehouse\\Mikropuhe5"

// Miss pidetn viimeksi valitun nen GUIDia, tmn kirjoittaa ainoastaan mp5sapi.exe, dll ei puutu thn
#define MP_REG_GUIDOLETUSMODE	"Oletusmode"


// Mit nt kytetn jos kukaan ei ole kertonut viel
#define GUID_MPOLETUSAANI	GUID_MPRIKU

////////////////////////////////////////////////
// Nm interfacet ovat samat kuin versiolla 4.2
// {3EEA6B61-BA86-11d2-B984-00104B8A8310}
DEFINE_GUID(IID_IMPUIRaja, 
0x3eea6b61, 0xba86, 0x11d2, 0xb9, 0x84, 0x0, 0x10, 0x4b, 0x8a, 0x83, 0x10);

DEFINE_GUID(IID_IMPUINotify, 
0x3eea6b61, 0xba86, 0x11d2, 0xb9, 0x84, 0x0, 0x10, 0x4b, 0x8a, 0x83, 0x11);

// Nm interfacet ovat samat kuin versiolla 4.2
////////////////////////////////////////////////


// Mikropuhe-objektin GUID, versiolla 5 omansa
// {E219F92E-EC3E-4db5-92B8-8E7FDECAC568}
DEFINE_GUID(CLSID_MPBase, 
0xe219f92e, 0xec3e, 0x4db5, 0x92, 0xb8, 0x8e, 0x7f, 0xde, 0xca, 0xc5, 0x68);


////////////////////////////////////////////////
// Puhenill omat GUIDit

// Mikropuheen kyttmien nten GUIDit. Vain viimeinen vaihtuu, 
// Viimeisen alin bitti: 0=16bit mono 22050 Hz, 1=16bit mono 8000 Hz

// {FC581A6E-B649-4a4a-ACE1-69D5EC71DD00}, MP42 kytt samaa nime GUID_MP_MODEBASE, vaan GUID on eri
DEFINE_GUID(GUID_MP_MODEBASE, 
0xfc581a6e, 0xb649, 0x4a4a, 0xac, 0xe1, 0x69, 0xd5, 0xec, 0x71, 0xdd, 0x00);


// Rikun ni normaali
// {FC581A6E-B649-4a4a-ACE1-69D5EC71DD10}
DEFINE_GUID(GUID_MPRIKU, 
0xfc581a6e, 0xb649, 0x4a4a, 0xac, 0xe1, 0x69, 0xd5, 0xec, 0x71, 0xdd, 0x10);


// Mikon ni normaali
// {FC581A6E-B649-4a4a-ACE1-69D5EC71DD14}
DEFINE_GUID(GUID_MPMIKKO, 
0xfc581a6e, 0xb649, 0x4a4a, 0xac, 0xe1, 0x69, 0xd5, 0xec, 0x71, 0xdd, 0x14);

// Petterin ni normaali 
// {FC581A6E-B649-4a4a-ACE1-69D5EC71DD18}
DEFINE_GUID(GUID_MPPETTERI,
0xfc581a6e, 0xb649, 0x4a4a, 0xac, 0xe1, 0x69, 0xd5, 0xec, 0x71, 0xdd, 0x18);

// Sagan ni normaali 
// {FC581A6E-B649-4a4a-ACE1-69D5EC71DD1C}
DEFINE_GUID(GUID_MPSAGA, 
0xfc581a6e, 0xb649, 0x4a4a, 0xac, 0xe1, 0x69, 0xd5, 0xec, 0x71, 0xdd, 0x1C);

// Puhenill omat GUIDit
////////////////////////////////////////////////


DECLARE_INTERFACE_ (IMPUIRaja, IUnknown) 
{
   /*
	*	IMPUIRaja members
	*/

	enum {
		FLAGS_SUORITA		= 1,		// Suoritetaanko komentoa vai onko kyseess initmenu
		FLAGS_PADLG_NKL	= 2,		// Puhearvodialogi NKL-malliin
		// Aina mukana FLAGS_PADLG_DEFAULTMODE = 4,	// Lis puhearvodialogiin puhenen valinta

		FLAGS_TULK_OMA		= 4,		// Ksittele omaa tulkintalistaa
		FLAGS_TULK_SAVEAS	= 8,		// Kysele aina talletusnime (TulkSave-funktio)
		FLAGS_TULK_SAVEDIRTY =16,	// Talleta vain jos on muokattu varmistuksen jlkeen
		FLAGS_TULK_NONOTIFY =32,	// Jtetnk lhettmtt tieto kaikille instansseille tulkinnan muuttumisesta
		FLAGS_TULK_OPENSILENT=64,	// Avaa ilman mitn ilmoituksia ja peru jos on tallettamatta (kun muu instanssi lhett tiedon vaihtumisesta)

		FLAGS_MODELESS		= 128		// Duunataanko modeless-dialogit PuheArvotDlg ja TulkDlg-tapauksissa
	};

	// GetWnd-kutsun lMika bittej yhdistelemll
	enum {
		WND_TULKDLG = 1,				// Tulkintadialogi
		WND_PADLG = 2,					// Puhearvojen stdialogi

		WND_ALL = -1					// Kaikki
	};

	/*
	*	Nytt puhearvodialogin tai kertoo voiko sit yleenskn nytt. Puhearvot talletetaan automaattisesti
	*
	*	hWndParent	-> Dialogin omistajaikkuna. Dialogi on modeless-tyyppinen
	*	lFlags		-> Mit tehdn
	*
	*	Palaute: NOERROR=Ok, S_FALSE=Ei kykene (ei tule koskaan)
	*/
   STDMETHOD (PuheArvoDlg)		(THIS_ HWND hWndParent, LONG lFlags) PURE;

	/*
	*	Nytt tulkintadialogin tai kertoo voiko sen nytt
	*
	*	hWndParent	-> Dialogin omistajaikkuna. Dialogi on modeless-tyyppinen
	*	lFlags		-> Mit tehdn, FLAGS_TULK_OMA ei vaikuta kun dialogissa nkyy kerralla kaikki
	*
	*	Palaute: NOERROR=Ok, S_FALSE=Ei kykene (ei tule koskaan)
	*/
   STDMETHOD (TulkDlg)			(THIS_ HWND hWndParent, LONG lFlags) PURE;

	/*
	*	Avaa tulkintatiedoston
	*
	*	hWndParent	-> Dialogin tai virheilmoitusten omistajaikkuna. Dialogi on modal-tyyppinen
	*	lFlags		-> Mit tehdn (normaali/oma, suorita/menuinit)
	*	pFileNimi	-> Ladattavan tiedoston nimi, NULL=Kysele itse
	*
	*	Palaute: NOERROR=Ok, S_FALSE=Ei kykene (ei tule koskaan)
	*/
   STDMETHOD (TulkOpen)			(THIS_ HWND hWndParent, LONG lFlags, LPCSTR pFileNimi) PURE;

	/*
	*	Tallettaa tulkintatiedoston
	*
	*	hWndParent	-> Dialogin tai virheilmoitusten omistajaikkuna. Dialogi on modal-tyyppinen
	*	lFlags		-> Mit tehdn (normaali/oma, suorita/menuinit), FLAGS_TULK_SAVEAS voip olla tss mys
	*	pFileNimi	-> Mihin talletetaan, NULL=Kyt alkuperist nime
	*
	*	Palaute: NOERROR=Ok, S_FALSE=Ei kykene
	*/
   STDMETHOD (TulkSave)			(THIS_ HWND hWndParent, LONG lFlags, LPCSTR pFileNimi) PURE;

	/*
	*	Kertoo ikkunakahvan.
	*
	*	lMika			-> Mik ikkuna, WND_xxx
	*	phWndVast	-> Vastaus, 0 jos ei ollut ikkunaa
	*
	*	Palaute: NOERROR=Ok, E_FAIL=Ei ole kyseist ikkunaa olemassa
	*/
   STDMETHOD (GetWnd)			(THIS_ LONG lMika, HWND *phWndVast) PURE;

	/*
	*	Sulkee ikkunan
	*
	*	lMika			-> Mik ikkuna, WND_xxx
	*
	*	Palaute: NOERROR=Ok/ei ollut ikkunaa, E_FAIL=Ei pysty sulkemaan ja syy kerrottu
	*/
   STDMETHOD (CloseWnd)			(THIS_ LONG lMika) PURE;

	/*
	*	Hoitelee Mikropuheen modeless-dialogeille tarkoitettuja viestej
	*
	*	prMsg	-> Mit tuli
	*
	*	Palaute: S_OK=Hoideltu on, S_FALSE=Ei ole viesti hoideltu
	*/
	STDMETHOD (PreTranslateMessage)(THIS_ MSG *prMsg) PURE;

	/*
	*	Hoitelee Mikropuheen modeless-dialogeille tarkoitettuja viestej
	*
	*	rIID		-> Mik rajapinta
	*	pNotify	-> NULL=Unohda vanha
	*
	*	Palaute: NOERROR=Ok, E_NOINTERFACE=Ei tajuta, muut=Hmr vika
	*/
	STDMETHOD (SetUINotify)(THIS_ IID rIID, interface IMPUINotify *pNotify) PURE;

	enum {
		SELECTEX_8BIT = 1					// Tuotetaankin 8-bittist signaalia 16-bittisen sijaan
	};

	// ITTSEnum-kutsu jolle voi antaa lismreit
	STDMETHOD (SelectEx)( GUID gModeID, PITTSCENTRALA *ppITTSCentral, LPUNKNOWN pAudio, LONG lFlags ) PURE;

	// Kertoo onko puhejonossa kamaa (PuhuukoMP nimi ettei mene sekaisin sisisten funktionimien kanssa)
	// Viimeinen puhuttu notify tulee millisekkoja ennen audionloppumisnotify
	STDMETHOD_(LONG, PuhuukoMP)( void ) PURE;

	// Lisparametrina puhuvan ohjelman nimi
   STDMETHOD (TextData2)(THIS_ VOICECHARSET eCharacterSet, DWORD dwFlags, SDATA dText, PVOID pNotifyInterface, IID IIDNotifyInterface, LPCSTR pPuhuvaExe ) PURE;
};

typedef IMPUIRaja FAR * PIMPUIRaja;


// Mikropuheen lhettmi notifyj
DECLARE_INTERFACE_ (IMPUINotify, IUnknown)
{
	enum {
		DLGEVENT_CREATE = 0,						// Dialogi luotu, kutsutaan WM_INITDIALOG lopuksi
		DLGEVENT_DESTROY							// Dialogi tuhoutumassa, kutsutaan WM_DESTROY aluksi
	};

	/*
	*	Kutsutaan kun jokin kyttliittymn dialogi luodaan/tuhotaan
	*
	*	hWnd		-> Dialogi, voit liikuttaa tt tai kysell paikkaa
	*	lEvent	-> DLGEVENT_xxx
	*	lID		-> Dialogin ID, 16-bittinen arvo
	*
	*	Palautetta ei kytet, palauta NOERROR
	*/
   STDMETHOD (OnDialogEvent)(THIS_ HWND hWnd, LONG lEvent, LONG lID) PURE;

	/*
	*	Kutsutaan kun oletuspuhent vaihdetaan.
	*
	*	rGuidMode	-> Puhenen tunnus
	*
	*	Palautetta ei kytet, palauta NOERROR
	*/
   STDMETHOD (OnDefaultModeChanged)(GUID rGuidMode) PURE;
};

typedef IMPUINotify FAR * PIMPUINotify;

#endif
