 #Doubletalk SynthDriver 2011 Tyler Spivey <tspivey@pcdesk.net>
PORT="com5"
import threading
import Queue
import synthDriverHandler
from synthDriverHandler import SynthDriver
import speech
import serial
import logging
lastindex = 0
minRate = 0
maxRate = 9
minPitch = 0
maxPitch = 99
minInflection=0
maxInflection=9

#This can't terminate...
class IndexingThread(threading.Thread):
 def run(self):
  global lastindex
  while True:
   byte = port.read(1)
   lastindex = ord(byte)

def clear_queue(q):
 try:
  while True:
   q.get_nowait()
 except:
  pass

port = None
serialQueue = Queue.Queue()
class BgThread(threading.Thread):
 def __init__(self, q):
  threading.Thread.__init__(self)
  self.setDaemon(True)
  self.q = q

 def run(self):
  try:
   while True:
    func, args, kwargs = self.q.get()
    if not func:
     break
    func(*args, **kwargs)
    self.q.task_done()
  except:
   logging.error("bgThread.run", exc_info=True)

def _bgExec(q, func, *args, **kwargs):
 q.put((func, args, kwargs))

def bgWrite(text):
 #timeout errors. Ignore all errors for now, fix later to ignore the specific error
 try:
  port.write(text)
 except:
  pass


class SynthDriver(SynthDriver):
 name = "keynote"
 description = "Keynote Gold"
 supportedSettings = (SynthDriver.RateSetting(10),SynthDriver.PitchSetting(10),SynthDriver.InflectionSetting(10))

 @classmethod
 def check(cls):
  return True

 def __init__(self):
  global port
  port = serial.serial_for_url(PORT, 9600)
  port.setDsrDtr(0)
  self.serialThread = BgThread(serialQueue)
  self.serialThread.start()
  self.indexingThread = IndexingThread()
  self.indexingThread.start()
  self.dt_rate = 9
  self.dt_pitch = 50
  self.dt_inflection = 5

 def speak(self, speechSequence):
  text_list = []
  for item in speechSequence:
   if isinstance(item, basestring):
    text_list.append(item)
   elif isinstance(item,speech.IndexCommand):
    text_list.append("%d" % item.index)
  #No unicode here. Do something better with this later

  text = u" ".join(text_list).encode('ascii', 'replace')
  text =  (text)

  if text:
   _bgExec(serialQueue, bgWrite, ''+text+'}'+'\r')

 def cancel(self):
  clear_queue(serialQueue)
  try:
   port.write('\x03')
  except serial.SerialTimeoutException:
   pass

 def _set_rate(self, vl):
  self.dt_rate = self._percentToParam(vl,minRate,maxRate)

 def _get_rate(self):
  return self._paramToPercent(self.dt_rate, minRate, maxRate)

 def _set_pitch(self, vl):
  self.dt_pitch = self._percentToParam(vl, minPitch, maxPitch)

 def _get_pitch(self):
  return self._paramToPercent(self.dt_pitch, minPitch, maxPitch)

 def _set_inflection(self, vl):
  self.dt_inflection = self._percentToParam(vl,minInflection,maxInflection)

 def _get_inflection(self):
  return self._paramToPercent(self.dt_inflection, minInflection, maxInflection)

 def terminate(self):
  serialQueue.put((None, None, None))
  port.close()

 def _get_lastIndex(self):
  return lastindex
