from PyObjCTools import AppHelper
from AppKit import NSObject
from AppKit import NSSpeechSynthesizer
import threading
import struct
import serversocket

class QueuedSynth(NSObject):
 def init_(self, handler):
  self = super(QueuedSynth, self).init()
  self.synth = NSSpeechSynthesizer.alloc().init()
  self.speaking = False
  self.lock = threading.Lock()
  self.synth.setDelegate_(self)
  self.queue = []
  self.last_index = None
  self.handle_index = handler
  return self

 def speak(self, text, index=None):
  with self.lock:
   self.queue.append(('[[pbas 42]] [[pmod 180]] '+text, index))
   if self.speaking:
    return
   self.speak_more()

 def speechSynthesizer_didFinishSpeaking_(self, synth, success):
  with self.lock:
   if not self.speaking:
    return
   if self.last_index:
    self.handle_index(self.last_index)
   if len(self.queue) == 0:
    self.speaking = False
    return
   self.speak_more()

 def speak_more(self):
  text, index = self.queue.pop(0)
  self.synth.startSpeakingString_(text)
  self.speaking = True
  self.last_index = index

 def stop(self):
  with self.lock:
   self.synth.stopSpeaking()
   self.speaking = False
   self.queue = []

 def speechSynthesizer_didEncounterSyncMessage_(self, synth, message):
  #Decode the sync message. NSSPeechSynthesizer turns the passed int into a string.
  n = struct.unpack('<i', message.encode('mac-roman'))[0]
  self.handle_index(n)

class Client(serversocket.Client):
 def __init__(self, server, socket):
  super(Client, self).__init__(server, socket)
  self.synth = QueuedSynth.alloc().init_(handler=self.handle_index)

 def do_speak(self, parsed):
  if 'text' not in parsed:
   return
  text = parsed['text']
  index = parsed.get('index', None)
  AppHelper.callAfter(self.synth.speak, text, index)

 def do_stop(self, parsed):
  self.synth.stop()

 def handle_index(self, n):
  self.send('index', index=n)

serversocket.Client = Client
server = serversocket.Server(7968)
t = threading.Thread(target=server.run)
t.daemon = True
t.start()
AppHelper.runConsoleEventLoop()
