{ anplay -- play annotation regions of speech signal }
program anplay;

{$I tools.inc }

var
	base:annotation_record_ptr;
	ptr:annotation_record_ptr;
	fname:string;
	sprate:real;
	i,j:integer;
	wv:waveform;

begin
	write ('Enter SFS filename: ');
	readln(fname);
	if not SFSFile(fname) then
		writeln(fname,' is not an SFS file.')
	else if not SFSItem('sp') then
		writeln(fname,' does not contain a Speech item.')		
	else if not SFSItem('an') then
		writeln(fname,' does not contain an Annotation item.')
	else begin
		sprate := SpeechRate;
		if not LoadAnnotations(base,sprate) then
			writeln('Could not load annotations')
		else begin
			ptr := base;
			if ptr <> nil then repeat
				if ptr^.next <> nil then begin
					wv := SpeechPart(ptr^.sample,ptr^.next^.sample);
					ReplayWaveform(wv);
					for i:=1 to 100000 do j:=j+i;
				end;
				ptr := ptr^.next;
			until ptr = nil;
		end;
	end;
end.
