{ catsave -- use annotations for concatenation and save to file }
program catsave;

{$I tools.inc }

const
	MAXLINE=80;
var
	fname:string;
	ofname:string;
	sprate:real;
	inwv,wv:waveform;
	inline:array[0..MAXLINE] of string;
	incnt:integer;

procedure loadfile;
var
	fname:string;
begin
	write ('Enter Input SFS filename: ');
	readln(fname);
	write ('Enter Output SFS filename: ');
	readln(ofname);
	if not SFSFile(ofname) then
		abort(ofname+' is not an SFS file.')
	else if not SFSFile(fname) then
		abort(fname+' is not an SFS file.')
	else if not SFSItem('sp') then
		abort(fname+' does not contain a Speech item.')		
	else if not SFSItem('an') then
		abort(fname+' does not contain an Annotation item.')
	else begin
		sprate := SpeechRate;
		if not AnnotationLoad(sprate) then
			abort('could not load annotations');
		inwv := SpeechLoad;
	end;
end;

procedure listannot;
var
	ptr:annotation_record_ptr;
begin
	writeln;
	writeln('Units available are:');
	ptr := annot_base_ptr;
	if ptr <> nil then repeat
		if ptr^.next <> nil then
			write('  ',ptr^.annot);
		ptr := ptr^.next;
	until ptr = nil;
	writeln;
end;

function getline:boolean;
var
	wrd:string;
begin
	if eof(input) then
		getline:=false
	else begin
		incnt:=0;
		while not eoln(input) do begin
			read(wrd);
			inline[incnt] := wrd;
			incnt := incnt+1;
		end;
		readln;
		getline := true;
	end;
end;

function makesignal:waveform;
var
	i:integer;
	ssamp,esamp:integer;
	wv:waveform;
begin
	wv := NewWaveform(0,sprate);
	for i:=0 to incnt-1 do begin
		if (AnnotationFind(inline[i],ssamp,esamp)) then
			wv := wv + CutWaveform(inwv,ssamp,esamp)
		else
			writeln('No such annotation "',inline[i],'"');
	end;
	makesignal := wv;
end;

var
	count:integer;

procedure dosave;
var
	entry:string;
	hist:string;
begin
	entry:=str(count);
	count := count + 1;
	hist := 'entry='+entry;
	SpeechSave(ofname,hist,wv);
end;

begin
	count:=1;
	loadfile;
	listannot;
	write('Enter sentence (q to quit): ');
	while getline and (inline[0] <> str('q')) do begin
		if incnt <> 0 then begin
			wv:=makesignal;
			dosave(wv);
		end;
		listannot;
		write('Enter sentence (q to quit): ');
	end;
end.
