{ sgraph - display a simple graph }
program sgraph;

const
	WAVSIZ=256;
type
	wavtype=array[0..WAVSIZ] of real;
var
	wav:wavtype;
	i:integer;

{$I tools.inc }
{$I graph.inc }
external function _Random:integer;

begin

	GraphInit(output,1,2,'Waveform Generation');

	for i:=0 to WAVSIZ do wav[i] := sin(i*2.0*3.141593/16);

	GraphPlotY(1,1.0,wav,WAVSIZ,'Time','Amplitude','Sine Wave');

	for i:=0 to WAVSIZ do wav[i] := (_Random mod 32768)/16384.0 - 1.0;

	GraphPlotY(2,1.0,wav,WAVSIZ,'Time','Amplitude','Noise');

	GraphEnd;

end.
