/* digdata -- device independent graphics control data structure */

#include "SFSCONFG.h"
#include "dig.h"

#ifndef DOS
#include <termio.h>
#ifdef SUN
#ifdef __GNUC__
/* defines from termio that work with GNU gcc */
#undef TCGETA
#define TCGETA		(_IOC_OUT|((sizeof(struct termio)&_IOCPARM_MASK)<<16)|('T'<<8)|1)
#undef TCSETA
#define	TCSETA		(_IOC_IN|((sizeof(struct termio)&_IOCPARM_MASK)<<16)|('T'<<8)|2)
#endif
#endif
#endif

/* low-level device characteristics data structure */
struct digdevice {
	int   	nhoriz,nvert;		/* Screen size in pixels */
	float 	aspect;			/* pixel height/width */
	int     chwidth;		/* width of hardware text character in pixels */
	int	chheight;		/* height of h/w text char in pixels */
	int	greylevels;		/* number of displayable greyscales */
	int	greypixwidth;		/* width of greyscale pixel */
	int	greypixheight;		/* height of greyscale pixel */

	/* add new entries to end of this structure */
};

/* DIG operation data structure */
struct DIGDATA {
/* device selection */
	int	select;			/* current device selection */
	int	device;			/* current device code */
	int	subtype;		/* current device sub-type */
	int	setup;			/* structure initialised */
	FILE  	*outfile;		/* output file pointer */

/* real co-ordinates */
	float 	xscale,yscale ;		/* pixels/unit */
	float 	xorig,yorig ;		/* origin + 0.5 in pixels */
	float 	horiz,vert ;		/* Screen size in real units */
	int	xpen,ypen;		/* current graphics plot point */

/* vector font control */
	short 	*fontind;		/* indexes into fontvec	*/
	char 	*fontvec;		/* current vector font	*/

/* mouse control */
#ifndef DOS
	struct 	termio 	oldmode;	/* old terminal descriptor */
#endif
	int	tty;			/* file descriptor for keyboard */
	int	xmouse,ymouse;		/* mouse position in pixels */
	int	smouse;			/* mouse switch */
	int     mousestate;		/* current state of mouse */

/* device parameters */
	int   	nhoriz,nvert;		/* Screen size in pixels */
	int   	clipxmin,clipxmax;	/* x limits in pixels */
	int   	clipymin,clipymax;	/* y limits in pixels */
	float 	aspect;			/* pixel height/width */
	int     chwidth;		/* width of hardware text character in pixels */
	int	chheight;		/* height of h/w text char in pixels */
	int	cheightmin;		/* min legible vtext char height in pixels */
	struct digdevice digdev;	/* low-level device details */

} digdata;

