/* gstart - SFS graphics initialisation */

/* contains routines: digstart, digend, digquit */

/* M.A. Huckvale - University College London */

/* DIG version 3 - October 1989 */

/* version 3.1 - April 1997
	- allow device coding from DIGMAP to be
          specified directly in environment variable
*/
                  
#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#ifdef MASSCOMP
#include <sys/ioctl.h>
#endif
#ifdef DOS
#include <io.h>
#endif
#include <fcntl.h>
#include <signal.h>
#include "dig.h"
#include "digdata.h" 
#include "digtable.h"

/* forward declarations */
void	digend();
void	digquit();
#ifdef __STDC__
void	digint(int dummy);
#else
void	digint();
#endif
char	*sfsbase();

/* digstart -- start up graphics on device */
void	digstart (dev,fileptr,trapints)
char 	dev;				/* force device code */
FILE 	*fileptr;			/* force output stream */
int 	trapints;			/* 1 for auto interrupt trapping  */
{
	FILE		*tp;		/* terminal file pointer */
	char		tfcode,tfname[SFSMAXFILENAME];	/* terminal file code & name */
	int		tfsubtype;	/* terminal sub-type */
	char		*env,*getenv();	/* environment pointer */
	char		termname[SFSMAXFILENAME];	/* terminal name */
	char		devname[SFSMAXFILENAME];	/* device name */
	char		devcode=0;	/* selected code */
	int		devsubtype=0;	/* selected subtype */
	int		i;

	/* default device name */
	devname[0]=dev;
	devname[1]='\0';

	/* open terminal mapping file */
	strcpy(termname,sfsbase());
	strcat(termname,"/data/digmap");
	tp=fopen(termname,"r");

	/* check if specific device requested */
	if ((dev==DIG_DEFAULT_TERM) || (dev==' ')) {
		/* see if talking to a terminal */
		if (isatty(1) || ((env=getenv("GFORCE"))!=NULL)) {
			/* try to auto select device */
			if ((env=getenv("GTERM")))
				strcpy(devname,env);
			else if ((env=getenv("TERM")))
				strcpy(devname,env);
#ifdef DIG_DEFAULT_DEVICE_TYPE
			else {
				devname[0]='\0';
				devcode = DIG_DEFAULT_DEVICE_TYPE;
#ifdef DIG_DEFAULT_DEVICE_SUB
				devsubtype = DIG_DEFAULT_DEVICE_SUB;
#endif
			}
#else
			else
				strcpy(devname,"metafile");
#endif
			/* scan terminal map file */
			if (tp) {
				while (fscanf(tp,"%c %d %s\n",&tfcode,&tfsubtype,tfname)==3) {
					if (strcmp(tfname,devname)==0) {
						devcode = tfcode;
						devsubtype = tfsubtype;
					}
				}
			}
		}
		else {
			/* output is redirected - use metafile */
			devcode='o';
			devsubtype=0;
			/* backwards compatibility for NULL file ptr */
			if (!fileptr) fileptr=stdout;
#ifdef DOS
			setmode(1,O_BINARY);
#endif
		}			
	}
	else if (dev==DIG_DEFAULT_PRINTER) {
		/* request printer */
		if ((env=getenv("GPRINT")))
			strcpy(devname,env);
#ifdef DIG_DEFAULT_PRINT_TYPE
		else {
			devname[0]='\0';
			devcode = DIG_DEFAULT_PRINT_TYPE;
#ifdef DIG_DEFAULT_PRINT_SUB
			devsubtype = DIG_DEFAULT_PRINT_SUB;
#endif
		}
#else
		else
			strcpy(devname,"printer");
#endif

		/* scan terminal map file */
		if (tp) {
			while (fscanf(tp,"%c %d %s\n",&tfcode,&tfsubtype,tfname)==3) {
				if (strcmp(tfname,devname)==0) {
					devcode = tfcode;
					devsubtype = tfsubtype;
				}
			}
		}
	}
	else {
		/* requested terminal type - check legal */
		if (tp) {
			while (fscanf(tp,"%c %d %s\n",&tfcode,&tfsubtype,tfname)==3) {
				if (tfcode == dev) {
					devcode = tfcode;
					devsubtype = tfsubtype;
				}
			}
		}
	}
	if (tp) fclose(tp);
	if (devcode==0) {
		/* not found yet - try default */
#ifdef DIG_DEFAULT_DEVICE_TYPE
		devcode = DIG_DEFAULT_DEVICE_TYPE;
#ifdef DIG_DEFAULT_DEVICE_SUB
		devsubtype = DIG_DEFAULT_DEVICE_SUB;
#endif
#else
		/* no default allow to be specified in devname directly */
		devcode = devname[0];
		if (!isdigit(devname[1]))
			error("(dig) unable to set graphics device type for '%s'",devname);
		devsubtype = atoi(devname+1);
#endif
	}		
		
	/* map device character to table pointer */
	digdata.select = -1;
	for (i=0;i<digtablesize;i++)
		if (devcode == digtable[i].devcode)
			digdata.select = i;
			
	/* check everything ok so far */
	if (digdata.select < 0)
		error("(dig) unable to set graphics device type for '%s'",devname);

	/* get primary parameters of output device */
	digdata.subtype = devsubtype;
	memset((char *)&digdata.digdev,0,sizeof(struct digdevice));
	(*digtable[digdata.select].params)(digdata.subtype,&digdata.digdev);

	/* move commonly used details up to old positions */
	digdata.nhoriz        = digdata.digdev.nhoriz;
	digdata.nvert         = digdata.digdev.nvert;
	digdata.aspect        = digdata.digdev.aspect;
	digdata.chwidth       = digdata.digdev.chwidth;
	digdata.chheight      = digdata.digdev.chheight;

	/* request an output file pointer */
	if (!fileptr) {
		/* does device need an output file ptr */
		if (digtable[digdata.select].outfile)
			(*digtable[digdata.select].outfile)(
				&digdata.outfile);
		else
			digdata.outfile = stdout;
	}
	else
		digdata.outfile = fileptr;
#ifdef DOS
	setmode(fileno(digdata.outfile),O_BINARY);
#endif

	/* initialise digdata structure */
	digdata.device     = devcode;
	digdata.cheightmin = digdata.chheight/2;
	digdata.clipxmin   = digdata.clipymin = 0;
	digdata.clipxmax   = digdata.nhoriz-1;
	digdata.clipymax   = digdata.nvert-1;
	if (digdata.setup == 0) digdata.tty = -1;
	digdata.setup = 1;

	/* set up default real scaling */
	digscale((float)1.0,(float)1.0,0);

	/* trap interrupts for user, if requested */
	if (trapints) {
		if (signal(SIGINT,SIG_IGN) != SIG_IGN) 
			signal(SIGINT,digint);
	}

	/* open the graphics device */
	(*digtable[digdata.select].open)();

	/* make sure graphics closed on exit */
#if defined(SUN4) && !defined(SVR4) && !defined(SOLARIS)
	on_exit(digend,1);
#else
#ifdef __STDC__
	atexit(digend);
#endif
#endif
}

/* digint -- interrupt routine */
void digint(dummy)
int dummy;
{
	/* call device-specific interrupt routine */
	if (digtable[digdata.select].inter)
		(*digtable[digdata.select].inter)();
	digquit(0);
	exit(1);
}

/* digend - close graphics */
void	digend ()
{
	digquit(0);
}

/* digquit(action) - perform action then call digend */
/*
	action = 0	Nothing
		 1	wait for CR (call digwait())
		 2	force clear screen (may be done anyway on some devices)

	values can be added together for multiple actions
*/

void	digquit(action)
int 	action;
{
	if (digdata.setup==0) return;

	/* flush existing lines */
	digflush();
	
	/* wait for key press */
	if ((action & 1) && (digdata.outfile==stdout)) digwait();

	/* clear screen */
	if (action & 2) digclearscreen();

	/* close raw keyboard channel if left open */
	if (digdata.tty >= 0) {
#ifndef DOS		
		ioctl (digdata.tty,TCSETA,&digdata.oldmode);
		close(digdata.tty);
#endif
		digdata.tty = -1;
	}

	/* close down graphics */
	(*digtable[digdata.select].close)();

	digdata.setup=0;

}


#ifdef EMO
#include <conio.h>
main()
{
	char	dev[80];
	FILE	*fptr,*devnull;
	int	ifile;

#ifdef MSDOS
	devnull = fopen("NUL:","w");
#else
	devnull = fopen("/dev/null","w");
#endif
	fprintf(stderr,"Enter device letter (or 0): ");
	scanf("%s",dev);
	if ((*dev == '0') || (*dev == '\n')) *dev = '\0';

	fprintf(stderr,"Enter file spec: 0=NULL, 1=stdout, 2=file: ");
	scanf("%d",&ifile);
	if (!ifile) 
		fptr = NULL;
	else if (ifile == 1) 
		fptr = stdout;
	else 
		fptr = devnull;

	digstart(*dev,fptr,0);
	digquit(0);

	fprintf(stderr,"                        x           y\n");
	fprintf(stderr,"Pixels/unit     %10g %10g\n",digdata.xscale,digdata.yscale);
	fprintf(stderr,"Origin(pix)     %10g %10g\n",digdata.xorig,digdata.yorig);
	fprintf(stderr,"Screen size     %10g %10g\n",digdata.horiz,digdata.vert);
	fprintf(stderr,"Pixel shape     %10g %10g\n",1.0,digdata.aspect);
	fprintf(stderr,"Screen pixels   %10d %10d\n",digdata.nhoriz,digdata.nvert);
	fprintf(stderr,"Clip min (pix)  %10d %10d\n",digdata.clipxmin,digdata.clipymin);
	fprintf(stderr,"Clip max (pix)  %10d %10d\n",digdata.clipxmax,digdata.clipymax);
	fprintf(stderr,"\n");
	fprintf(stderr,"Device code:      %c\n",digdata.device);
	fprintf(stderr,"Device subtype:   %d\n",digdata.subtype);
	fprintf(stderr,"Setup flag:       %d\n",digdata.setup);
	if (digdata.outfile == NULL) 
		fprintf(stderr,"Output file:  NULL\n");
	else if (digdata.outfile == stdout)
		fprintf(stderr,"Output file:  stdout\n");
	else if (digdata.outfile == devnull)
		fprintf(stderr,"Output file:  specified in call\n");
	else
		fprintf(stderr,"Output file: unknown (pipe or metafile)\n");
	fprintf(stderr,"Minimum char height (pix) :  %d\n",digdata.cheightmin);
	fprintf(stderr,"Hardware char width (pix) :  %d\n",digdata.chwidth);
	fprintf(stderr,"\nHit RETURN to exit ->"); fflush(stderr);
	getch();

	exit(0);
}
#endif

