/* xdig.h DIG X-windows graphics global data */

#define DEFAULT_WIDTH 800
#define DEFAULT_HEIGHT 600

struct  digDEVx_t {
	short subtype;		/* unused */
	short mode;		/* 0=closed, childpid=initialised */
	short currbun;		/* current bundle */
	short rop;		/* raster operation */
	int	pin;		/* parent input */
	int	pout;		/* parent output */
	int	cin;		/* child input */
	int	cout;		/* child output */
};

/* transfer buffers */
#define OBUFSIZE 4096		/* xdig -> xgraph transfer buffer size */
#define RCOMMLEN 32		/* xgraph -> xdig xfer fixed size */

/* xgraph message formats */
#define SCRMESS	"S %d %d %d %d %d"	/* width, height, chwidth,
					   chheight, ngrey */
#define MOUMESS	"M %d %d %d"		/* xpos, ypos, buttons */
#define RDWMESS	"R"			/* redraw */
#define KEYMESS	"K %d"			/* keyboard character */
#define QUITMESS "Q"			/* quit */

