/* xgraph - X-windows graphics support for xansi DIG library */

/* M.A.Huckvale - University College London */

/* version 0.1 - December 1992 */

#include "SFSCONFG.h"

#ifdef EVx

#include <stdio.h>
#include <ctype.h>
#include <sys/ioctl.h>
#include <X11/Xlib.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/canvas.h>
#include <xview/cms.h>
#include <xview/xv_xrect.h>
#include <xview/notify.h>
#include <xview/font.h>

#include "xdig.h"

#define MIN(x,y) (((x)<(y))?(x):(y))
#define MAX(x,y) (((x)>(y))?(x):(y))

extern struct digDEVx_t digDEVx;

/* global drawing variables */
static Frame 	frame;
static Canvas 	canvas;
static XID	xid;
static Display	*dpy;
static GC	gc;
static unsigned long *colours;

static int	wwidth=DEFAULT_WIDTH;
static int	wheight=DEFAULT_HEIGHT;
static int	fwidth=7;
static int	fheight=9;
static int	firstredraw=0;
static XFontStruct *fontinf;

/* colours */
#define NUM_COLOUR	32
static Xv_singlecolor cms_colours[NUM_COLOUR]={
	{ 250,250,250},	/* 0 = background */
	{ 200, 50, 50},	/* 1 */
	{ 100, 75,100},	/* 2 */
	{ 100, 75, 50},	/* 3 */
	{ 150,200,  0},	/* 4 */
	{  25, 25,100},	/* 5 = was red - mapped to dark grey/blue */
	{  50,200,100},	/* 6 */
	{  50,100,200},	/* 7 */
	{ 150,150,  0},	/* 8 */
	{  50, 50, 50},	/* 9 = was white - mapped to dark grey */
	{ 200,100,  0},	/* 10 */
	{ 100,  0,100},	/* 11 */
	{   0,100,100},	/* 12 */
	{ 200,100,100},	/* 13 */
	{  50,100,200},	/* 14 */
	{   0,  0,  0},	/* 15 = foreground */
	{ 250,250,250},	/* 16 */
	{ 248,248,248},	/* 17 */
	{ 244,244,244},	/* 18 */
	{ 238,238,238},	/* 19 */
	{ 230,230,230},	/* 20 */
	{ 220,220,220},	/* 21 */
 	{ 208,208,208},	/* 22 */
	{ 194,194,194},	/* 23 */
	{ 178,178,178},	/* 24 */
	{ 160,160,160},	/* 25 */
	{ 140,140,140},	/* 26 */
	{ 118,118,118},	/* 27 */
	{  94, 94, 94},	/* 28 */
	{  68, 68, 68},	/* 29 */
	{  40, 40, 40},	/* 30 */
	{  10, 10, 10},	/* 31 */
};

/*------------------------ the drawing bit -------------------------*/
void dographics()
{
	int 		quit();
 	void  		canvas_repaint_proc();
	Notify_value 	readevent();
	void		inpevent();
	Cms		cms;
	Xv_font		font;
	XGCValues	gcvalues;
	char		messg[32];

	/* initialise connection to X-Server */
	firstredraw=2;
 	xv_init(NULL);

	/* create a frame to hold graphics */
 	frame = (Frame)xv_create(NULL, FRAME, 
		FRAME_LABEL, 	"SFS/DIG", 
 		XV_WIDTH,	DEFAULT_WIDTH,
		XV_HEIGHT,	DEFAULT_HEIGHT,
		XV_SHOW,	TRUE,
		NULL);

	/* get some colours */
	cms = xv_create(NULL,CMS,
		CMS_SIZE,	NUM_COLOUR,
		CMS_TYPE,	XV_STATIC_CMS,
		CMS_COLORS,	cms_colours,
		NULL);

	/* create a canvas to draw graphics */
	canvas = (Canvas)xv_create(frame, CANVAS,
        	CANVAS_REPAINT_PROC,    canvas_repaint_proc,
        	CANVAS_X_PAINT_WINDOW,  TRUE,
		WIN_CMS,		cms,
        	NULL);

	/* get the colour map indices */
	colours = (unsigned long *)xv_get(canvas,WIN_X_COLOR_INDICES);

	/* fit the canvas to the frame */
	window_fit(canvas);

	/* get globals to access canvas */
	dpy = (Display *)xv_get(frame,XV_DISPLAY);
	xid = (XID)xv_get(canvas_paint_window(canvas),XV_XID);

	/* display what we've got so far */
	XFlush(dpy);

	/* get a suitable font */
	font = (Xv_font)xv_find(frame,FONT,FONT_NAME,"courier",NULL);
	if (!font)
		font = (Xv_font)xv_get(frame,XV_FONT);
	fwidth = xv_get(font,FONT_CHAR_WIDTH);
	fheight = xv_get(font,FONT_CHAR_HEIGHT);
	fontinf = (XFontStruct *)xv_get(font,FONT_INFO);

	/* set up graphics context with font */
	gcvalues.font = (Font)xv_get(font,XV_XID);
	gcvalues.foreground = BlackPixel(dpy,DefaultScreen(dpy));
	gcvalues.background = WhitePixel(dpy,DefaultScreen(dpy));
	gcvalues.graphics_exposures = False;
	gc = XCreateGC(dpy,RootWindow(dpy,DefaultScreen(dpy)),
		GCForeground | GCBackground | GCFont | GCGraphicsExposures,
		&gcvalues);

	/* set up an event handler based on inputs from parent */
	notify_set_input_func((Notify_client)10101,readevent,digDEVx.cin);

	/* set up an event handler for keyboard and mouse */
	xv_set(canvas_paint_window(canvas),WIN_CONSUME_EVENTS,
/*		WIN_NO_EVENTS, */
		WIN_ASCII_EVENTS,
		KBD_USE,
		KBD_DONE,
		WIN_MOUSE_BUTTONS,
		WIN_LEFT_KEYS,
		WIN_TOP_KEYS,
		WIN_RIGHT_KEYS,
		WIN_META_EVENTS,
		NULL,
		WIN_EVENT_PROC,inpevent,
		NULL);

	/* start the whole thing going ! */
	notify_start();

	/* get here if frame closed */
	sprintf(messg,QUITMESS);
	write(digDEVx.cout,messg,RCOMMLEN);

	/* that's it folks */
	exit(0);		/* terminate child process */
}

/* routine called whenever input ready from parent */
Notify_value
readevent(client,fd)
Notify_client	client;
int	fd;
{
	int		bytes,len;
	int		i,j;
	static char	cbuf[2*OBUFSIZE];	/* command buffer */
	static int	ipos=0;		/* input position */
	static int	opos=0;		/* output position */

	/* check that the input wasn't an error or EOF */
	if ((ioctl(fd,FIONREAD,&bytes) == -1) || (bytes==0))
		/* it was - halt event processing on this input */
		notify_set_input_func(client,NOTIFY_FUNC_NULL,fd);
	else do {

		/* get formatted commands from parent */
		len = MIN(MIN(bytes,OBUFSIZE),(2*OBUFSIZE-ipos));
		if ((len=read(fd,cbuf+ipos,len))>0) {
			ipos += len;
			/* process complete commands */
			do {
				/* find next newline */
				for (i=opos;(i<ipos) && (cbuf[i]!='\n');i++)
					/* scan */;

				/* check have command */
				if ((i<ipos) && (cbuf[i]=='\n')) {
					/* got one */
					cbuf[i] = '\0';
					decodecommand(cbuf+opos);
					/* move to start of next */
					opos = i + 1;
				}
				else {
					/* no complete commands left */
					for (i=0;i<(ipos-opos);i++)
						cbuf[i] = cbuf[i+opos];
					ipos -= opos;
					opos = 0;
					break;
				}
			} while (opos > 0);
		}
		bytes -= len;
	} while ((len > 0) && (bytes > 0));

	/* display what we've got so far */
	XFlush(dpy);

	return NOTIFY_DONE;
}

/* event handler for mouse and keyboard events */
void inpevent(window,event,arg)
Xv_Window	window;
Event		*event;
Notify_arg	arg;
{
	char	messg[RCOMMLEN];

	if (event_is_ascii(event)) {
		if (event_is_down(event)) {
			sprintf(messg,KEYMESS,event_action(event));
			write(digDEVx.cout,messg,RCOMMLEN);
		}
	}
	else switch (event_action(event)) {

	case ACTION_SELECT:	/* left button */
		sprintf(messg,MOUMESS,event_x(event),wheight-event_y(event)-1,
			event_is_down(event)?4:0);
		write(digDEVx.cout,messg,RCOMMLEN);
		break;

	case ACTION_ADJUST:	/* middle button */
		sprintf(messg,MOUMESS,event_x(event),wheight-event_y(event)-1,
			event_is_down(event)?2:0);
		write(digDEVx.cout,messg,RCOMMLEN);
		break;

	case ACTION_MENU:	/* right button */
		sprintf(messg,MOUMESS,event_x(event),wheight-event_y(event)-1,
			event_is_down(event)?1:0);
		write(digDEVx.cout,messg,RCOMMLEN);
		break;

	case ACTION_STOP:
	case WIN_DESTROY_NOTIFY:
	case ACTION_CLOSE:	/* close frame */
		sprintf(messg,QUITMESS);
		write(digDEVx.cout,messg,RCOMMLEN);
		break;

	case WIN_RESIZE:
	case WIN_REPAINT:
		if (firstredraw > 0)
			firstredraw--;
		else {
			sprintf(messg,RDWMESS);
			write(digDEVx.cout,messg,RCOMMLEN);
			printf("Request for redraw command sent from notifier (%d)\n",event_action(event));
		}
		break;

	case KBD_USE:
		/* ignore keyboard coming & going */
		break;

	default:
		printf("got event action %d\n",event_action(event));
	}

}

/* quit function */
int quit()
{
	char	messg[RCOMMLEN];

	xv_destroy_safe(frame);

	sprintf(messg,QUITMESS);
	write(digDEVx.cout,messg,RCOMMLEN);

	return(XV_OK);
}

/* repaint routine */
void canvas_repaint_proc(canvas, paint_window, dpy, xwin, xrects)
Canvas        canvas;         /* unused */
Xv_Window     paint_window;   /* unused */
Display      *dpy;
Window        xwin;
Xv_xrectlist *xrects;         /* unused */
{
/* SCRAP THE WHOLE THING
	char	messg[RCOMMLEN];

	if (firstredraw)
		firstredraw=0;
	else {
		sprintf(messg,RDWMESS);
		write(digDEVx.cout,messg,RCOMMLEN);

		printf("Request for redraw command sent from canvas\n");
	}
*/
}

/* map 100 bundles onto sun colors */
static unsigned long bundletosun(bun)
int bun;
{
	if (bun < 5)
		return(colours[bun]);
	else if (bun >= 100)
		return(colours[bun-84]);
	else {
		bun = bun % 15;
		if (bun==0) 
			return(colours[15]);
		else
			return(colours[bun]);
	}
}

/* do XLib drawing on command from parent */
decodecommand(com)
char *com;
{
	char	ccode;
	int	p1=0,p2=0;
	static int	lastx=0,lasty=0;
	static unsigned long lastcol=0;
	static	int	linemode=0;
	char	messg[RCOMMLEN];
	int	len;
	int	xl,yt,xr,yb;

	/* get drawing code */
	ccode = *com++;
	if (ccode != 't') {
		/* get numeric parameters */
		while (isdigit(*com)) p1 = 10*p1 + *com++ - '0';
		if (*com==';') {
			com++;
			while (isdigit(*com)) p2 = 10*p2 + *com++ - '0';
		}
		/* position for optional parameter */
		if (*com==';') com++;
	}

	switch (ccode) {

	case 'H':	/* text position */
		if (p1==0) p1 = 1;
		if (p2==0) p2 = 1;
		lasty = (fheight+1) * p1;
		lastx =  fwidth * (p2-1);
		break;
	case 'K':	/* text clear to EOL */
		XSetFunction(dpy,gc,GXclear);
		XFillRectangle(dpy,xid,gc,lastx,lasty-fheight-1,
				wwidth-lastx,fheight);
		XSetFunction(dpy,gc,(linemode)?GXxor:GXcopy);
		XFlush(dpy);
		break;
	case 'b':	/* filled rectangle */
		p2 = wheight - p2 -1;
		xl = MIN(lastx,p1);
		xr = MAX(lastx,p1);
		yt = MIN(lasty,p2);
		yb = MAX(lasty,p2);
		XFillRectangle(dpy,xid,gc,xl,yt,xr-xl+1,yb-yt+1);
		lastx = p1;
		lasty = p2;
		break;
	case 'd':	/* draw line */
		XDrawLine(dpy, xid, gc, lastx, lasty, p1, wheight-p2-1);
		lastx = p1;
		lasty = wheight-p2-1;
		break;
	case 'g':	/* graphics on/off */
		if (p1==0) quit();
		break;
	case 'h':	/* set hue */
		XSetForeground(dpy,gc,lastcol=bundletosun(p1));
		break;
	case 'k':	/* klear screen */
		XClearWindow(dpy,xid);
		break;
	case 'l':	/* draw/xor mode */
		linemode = p1;
		XSetFunction(dpy,gc,(p1)?GXxor:GXcopy);
		break;
	case 'o':	/* mouse on/off */
		/* DUMMY - not required here */
		break;
	case 'p':	/* position graphics cursor */
		lastx = p1;
		lasty = wheight-p2-1;
		break;
	case 'q':	/* query size */
		wwidth = xv_get(frame,XV_WIDTH);
		wheight = xv_get(frame,XV_HEIGHT);
		sprintf(messg,SCRMESS,wwidth,wheight,fwidth,fheight,16);
		write(digDEVx.cout,messg,RCOMMLEN);
		break;
	case 't':	/* text */
		len = strlen(com);
		XDrawString(dpy,xid,gc,lastx,lasty - fontinf->descent,
						com,len);
		lastx += len*fwidth;
		break;
	case 'x':	/* grey-scale line */
/*		printf("Grey scale %d height %d count='%s'\n",p1,p2,com); */
		break;
	default:
		fprintf(stderr,"Unknown drawing command: %c %d %d %s\n",
				ccode,p1,p2,com);
	}
}
#endif
