/* DSP routines from Mike Brookes, Imperial College London */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include "sfs.h"
#include "libic.h"

#define NAME "fpsr"

void fpsr(data,spect,len)
REAL *data;
REAL *spect;
int len;
/*
	Real fourier transform with len = 2**m

	data[len] -> spect[len/2 + 1]

        data and spect can be the same array if desired
*/
{
    static REAL *temp;
    static int tlen = 0;
    REAL *pdata,*pdatan,*pspect,*ptemp,*qtemp;
    REAL rlen;
    COMPLEX amp;
    int m;

/* First copy into temporary array */

    if (len < 8) error("%s: length (= %d) must be >= 8",NAME,len);
    if (len > tlen) {
	if (tlen) free(temp);
	temp = (REAL *) malloc(len * sizeof(REAL));
	tlen = len;
	}

    pdata = data;
    ptemp = temp;
    pdatan = data + len;
    rlen = 1.0/len;
    while(pdata < pdatan) *ptemp++ = rlen * *pdata++;

/* Now do the transform */

    m = log2ch(len);
    rbitrev(temp,len);
    rsplfft(temp,len,m);

/* now unravel the complex parts */

    ptemp = temp;
    qtemp = temp+len - 1;
    pspect = (REAL *) spect;
    amp.r = *ptemp++;
    *pspect++ = amp.r * amp.r;
    while (ptemp < qtemp) {
	amp.r = *ptemp++;
	amp.i = *qtemp--;
	*pspect++ = 2.0 * (amp.r * amp.r + amp.i * amp.i);
	}
    amp.r = *ptemp;
    *pspect++ = amp.r * amp.r;
    return;
    }
#ifdef EMO

#include <stdio.h>
#include <math.h>
#define LEN 32

main ()
{
    REAL data[LEN];
    REAL spect[1 + LEN/2];
    REAL sum,theta;
    int i;

    printf("Test for fpsr: 1.1 + 2cos(f) + 3sin(3f) + 4cos(%df)\n",LEN/2);
    for (i=0; i<LEN; i++) {
	theta = (TWOPI * i) / LEN;
	data[i] = 1.1 + 2.0*cos(theta) + 3.0*sin(3.0*theta) + 4.0*cos(theta*LEN/2);
	}

    fpsr(data,spect,LEN);

    for (i=0; i<=(LEN/2); i++) {
	if (spect[i] > 0.01) {
	    printf("%3d %8.2f rms\n",i,sqrt(spect[i]));
	    }
	}

    }
#endif
