/* lab_store -- store history in labels data base */

/* global declarations */
#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include "sfs.h"
#include "label.h"

/* store a history in the hist structure */
char	*lab_store(item)
struct item_header *item;
{
	int	i,j,it,ty,slen;
	register char	*s,*t,*e;

	/* check not in table already */
	for (i=0;i<lab_current;i++)
		if ((lab_hist[i].datatype==abs(item->datatype)) &&
		    (lab_hist[i].subtype==item->subtype))
			return(lab_hist[i].history);

	/* add item to table */
	lab_hist[lab_current].datatype=abs(item->datatype);
	lab_hist[lab_current].subtype=item->subtype;
	s = item->history;
	t = lab_hold;
	e = &lab_hold[MAXSTRING];
	while ((*s != '\0') && (*s != '(') && (t < e)) *t++ = *s++;
	if ((*s == '(') && (t < e)) {
		*t++ = *s++;
		/* expect zero or more item numbers */
		while (isdigit(*s) && (t < e)) {
			if (sscanf(s,"%d.%d",&it,&ty) != 2) return(item->history);
			for (i=0;i<lab_current;i++) 
				if ((lab_hist[i].datatype==it) && (lab_hist[i].subtype==ty)) {
					slen = strlen(lab_hist[i].history);
					for (j=0;(j<slen) && (t < e);j++) 
						*t++ = lab_hist[i].history[j];				}

			while (isdigit(*s) || (*s=='.')) s++;
			if ((*s != ',') && (*s != ')') && (*s != ';')) return(item->history);
			if (t < e) *t++ = *s++;
		}
		/* expect zero or more parameters */
		while ((*s != '\0') && (t < e)) *t++ = *s++;
	}
	*t='\0';
	if ((lab_hist[lab_current].history = (char *) malloc(strlen(lab_hold)+1))==NULL) 
		error("no room for malloc()",NULL);
	strcpy(lab_hist[lab_current].history,lab_hold);
	return(lab_hist[lab_current++].history);
}

/* reset internal tables */
void lab_reset()
{
	int	i;
	for (i=0;i<lab_current;i++) 
		if (lab_hist[i].history)
			free(lab_hist[i].history);
	lab_current=0;
}
	
#ifdef IAG
main()
{
	char	filename[80],*hist;
	struct item_header item;
	int	fid;

	printf("Enter filename : ");
	fflush(stdout);
	scanf("%s",filename);

	if ((fid=sfsopen(filename,"r",NULL)) < 0)
		error("cannot open %s",filename);

	while (sfsnextitem(fid,&item)) {
		hist=lab_store(&item);
		printf("%d.%02d %s\n",item.datatype,item.subtype,hist);
	}

	close(fid);
	exit(0);
}
#endif
