/* rmessage -- message definitions for Windows Replay Daemon */

#define XFERBUFFSIZE 0x0FF0

#define BYTE unsigned char
#define WORD unsigned short
#define DWORD unsigned long

#define	RMSG_CONN	1	/* connections */
#define RMSG_WAVE	2	/* waveform specification */
#define RMSG_XFER	3	/* xfer data command */
#define RMSG_REPL	4	/* replay command */

/* message structure */
union rmessage {
	char	mesg[XFERBUFFSIZE];
	struct {
		WORD	func;	/* determine function */
	} base;
	struct {
		WORD	func;	/* RMSG_CONN */
		WORD	flag;	/* 0=connect, 1=disconnect */
		DWORD	handle;	/* connection idnetifier */
	} conn;
	struct {
		WORD	func;	/* RMSG_WAVE */
		WORD	flag;	/* 0=new waveform, 1=free current */
		DWORD	handle;	/* connection idnetifier */
		DWORD	wsize;	/* # bytes for waveform */
		WORD	nbyte;	/* # bytes/sample */
		WORD	nchan;	/* # samples/frame */
		WORD	srate;	/* # frames/sec */
	} wave;
	struct {
		WORD	func;	/* RMSG_XFER */
		WORD	flag;	/* (unused) */
		DWORD	handle;	/* connection idnetifier */
		DWORD	offset;	/* buffer offset */
		WORD	xsize;	/* buffer count */
		BYTE	data[1];
	} xfer;
	struct {
		WORD	func;	/* RMSG_REPL */
		WORD	flag;	/* (unused) */
		DWORD	handle;	/* connection idnetifier */
		DWORD	offset;	/* replay offset */
		DWORD	count;	/* replay count */
	} repl;
};


