/* smanhtml -- create manual page from source file in HTML */

/* M.A.Huckvale - University College London */

/* version 1.0 - January 1998 */

#define PROGNAME "smanhtml"
#define PROGVERS "1.0"

/*--------------------------------------------------------------------------*/
/**MAN
.TH SMANHTML 1 SFS UTIL
.PM P
.SH NAME
smanhtml - filter out manual page from source file into HTML page
.SH SYNOPSIS
.B smanhtml
(sourcefile(s))
.SH DESCRIPTION
.I smanhtml 
reads text from its standard input or the filenames supplied and
reformats into HTML any nroff macros found between the markers /\****MAN 
and *\/. 
It is used to format manual pages from SFS source files (where authors
are requested to include the manual page in the file).
.SH VERSION/AUTHOR
1.0 - Mark Huckvale
*/
/*--------------------------------------------------------------------------*/

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "sfs.h"

void procline(char *str)
{
	char *fmt;
	char *arg;

	if (str[0]=='.') {
		fmt = strtok(str+1," \t\n");
		if (!fmt) fmt="";
		arg = strtok(NULL,"\n");
		if (!arg) arg="";
	}
	else {
		fmt = "";
		arg = strtok(str,"\n");
		if (!arg) arg="";
	}
	if (strcmp(fmt,"B")==0)
		printf("<B>%s</B>\n",arg);
	else if (strcmp(fmt,"I")==0)
		printf("<I>%s</I>\n",arg);
	else if (strcmp(fmt,"BI")==0) {
		printf("<B>%s</B> ",strtok(arg," \t\n"));
		printf("<I>%s</I>\n",strtok(NULL,"\n"));
	}
	else if (strcmp(fmt,"TH")==0)
		printf("<HR><P><H2>%s</H2>\n",strtok(arg," \t\n"));
	else if (strcmp(fmt,"SH")==0)
		printf("<H3>%s</H3>\n",arg);
	else if (strcmp(fmt,"SS")==0)
		printf("<H4>%s</H4>\n",arg);
	else if (strcmp(fmt,"PP")==0)
		printf("<P>");
	else if (strcmp(fmt,"sp")==0)
		printf("<P>");
	else if (strcmp(fmt,"TP")==0)
		printf("<P>");
	else if (strcmp(fmt,"IP")==0)
		printf("<P><I>%s</I>\n",strtok(arg," \t\n"));
	else if (strcmp(fmt,"nf")==0)
		printf("<pre>\n");
	else if (strcmp(fmt,"fi")==0)
		printf("</pre>\n");
	else if (strcmp(fmt,"br")==0)
		printf("<BR>");
	else if (*fmt && *arg)
		printf("{%s} %s\n",fmt,arg);
	else if (*fmt)
		printf("{%s}\n",fmt);
	else if (*arg)
		printf("%s\n",arg);
	else
		printf("\n");
}

void procfile(FILE *ip)
{
	char	iline[1024];
	int	start=0;

	while (fgets(iline,1024,ip)) {
		if (start && (strncmp(iline,"*/",2)==0)) break;
		if (start) procline(iline);
		if (strncmp(iline,"/**MAN",6)==0) start=1;
	}
}

int main(int argc,char **argv)
{
	extern int optind;
	extern char *optarg;
	int	c,errflg=0;
	FILE	*ip;
	
	while ((c=getopt(argc,argv,"I"))!=EOF) switch (c) {
	case 'I':
		fprintf(stderr,"%s: Get manual page from source in HTML Vs%s\n",PROGNAME,PROGVERS);
		exit(0);
	default:
		errflg=1;
		break;
	}
	if (errflg)
		error("usage: %s (-I) (sourcefiles)",PROGNAME);

	printf("<html><head><title>SFS Manual Page</title></head><body>\n");
	if (optind==argc)
		procfile(stdin);
	else for (;optind<argc;optind++) {
		if ((ip=fopen(argv[optind],"r"))==NULL)
			error("could not open '%s'",argv[optind]);
		procfile(ip);
		fclose(ip);
	}
	printf("</body></html>\n");
	exit(0);
}		
