/* complex.h - definitions for complex arithmetic */

/*
 * (c) 1994 Mark Huckvale
 * Search Systems Ltd
 * 52-54 High Holborn
 * London WC1E 6BT
 * Tel. 071-430 1685
 */

typedef struct complex_rec {
	double	re;
	double	im;
} COMPLEX;

/* complex.c */
#ifdef __STDC__
COMPLEX CMake(double re,double im);
COMPLEX CAdd(COMPLEX c1,COMPLEX c2);
COMPLEX CSub(COMPLEX c1,COMPLEX c2);
COMPLEX CMult(COMPLEX c1,COMPLEX c2);
COMPLEX CDiv(COMPLEX c1,COMPLEX c2);
double  CMag(COMPLEX c);
double  CArg(COMPLEX c);
COMPLEX CExp(COMPLEX c);
COMPLEX CSqrt(COMPLEX c);
COMPLEX CScale(COMPLEX c,double f);
#else
COMPLEX CMake();
COMPLEX CAdd();
COMPLEX CSub();
COMPLEX CMult();
COMPLEX CDiv();
double  CMag();
double  CArg();
COMPLEX CExp();
COMPLEX CSqrt();
COMPLEX CScale();
#endif

#define CPrint(c) printf("(%g+%gi)",c.re,c.im)
