/* sfsdata -- common data structure for sfsitem, sfsread, sfswrite, etc .. */

#define MAXFILES 256
#define SFSREAD 1
#define SFSWRITE 2
#define NETREAD 3

#ifdef __cplusplus
extern "C" {
#endif

/* file status table - accessed by fid */
struct sfsdata {
	/* file variables */
	int	mode;			/* SFSREAD=input, SFSWRITE=output */
	char	filename[SFSMAXFILENAME]; 	/* data file name */
	char	ofilename[SFSMAXFILENAME];	/* other file name */
	long	datastart;		/* position in file of data set */
	long	currpos;		/* current position in file */
	/* data variables */
	char	buff[512];		/* small buffer for small transfers */
	long	start;			/* # first frame in buffer */
	long	numf;			/* # frames in buffer */
	/* item variables */
	struct item_header item;	/* item header */
	/* link parameters */
	int	lfid;			/* linked file descriptor */
	/* data formatting */
	int	multiplex;		/* multiplexed data */
	int	swab;			/* swap bytes */
	int	dcoffset;		/* DC offset */
	int	shift;			/* bit shift */
} *sfsdata[MAXFILES];

#ifdef __cplusplus
}
#endif
