/* diggetmouse -- "processed" access to keyboard and pointing device */

#include "SFSCONFG.h"
#include <stdio.h>
#include <math.h>
#include "dig.h"
#include "digdata.h"

int	diggetmouse (str,but,xm,ym)
char 	*str;		/* returned keyboard string */
char	*but;		/* returned mouse button */
float 	*xm,*ym;	/* returned mouse co-ordinates */
{
	int	pxm,pym;	
	int 	ch;

	str[0]='\0';

	ch = diggetmousep(str,but,&pxm,&pym);

	/* convert to real co-ordinates */
	*xm = (pxm - digdata.xorig) / digdata.xscale;
	*ym = (pym - digdata.yorig) / digdata.yscale;

	return(ch);
}

int	diggetmousep(str,but,xm,ym)
char	*str;
char	*but;
int	*xm,*ym;
{
	static char	inbuff[85],*inptr=inbuff;
	static char	oldbut=0;
	int		erase1,erase2,ch;
	int		intbut;
	int		startx,curx;
	int		oldmode;
	int		i;

	/* get delete character */
	erase1 = 127;
	erase2 = 8;

	/* set up output string */
	curx = startx = digdata.xpen;	
	for (i=0;(i<80) && (str[i]!='\0');i++) {
		*inptr = str[i];
		*(inptr+1) = '\0';
		digtextp(24,curx,digdata.nvert-digdata.chheight-1,inptr);
		inptr++;
		curx += digdata.chwidth;
	}
	
	/* loop until we get string of characters or button press */
	do {

		/* loop until we get a real character or a mouse change */
		do {
	    		ch = diggetmousechp(&intbut,xm,ym);
			*but = intbut;
			if (*but != oldbut) {		/* if button change, return */
				oldbut = *but;
				return(ch);
			}
		} while (ch==DIG_MOUSE);

		/* process character */
		if ((ch==DIG_QUIT) || (ch==DIG_REDRAW))
			return(ch);
		if ((ch==erase1) || (ch==erase2)) {
			if (inptr==inbuff)
				putchar(BELL);
			else {
				curx -= digdata.chwidth;
				oldmode=diglinemode(0);
				digfillboxp(0,curx,digdata.nvert-digdata.chheight-2,
					curx+digdata.chwidth-1,digdata.nvert);
				diglinemode(oldmode);
				inptr--;
			}
		}
		else if ((ch==NEWLINE) || (ch=='\r') || (inptr>=(inbuff+79))) {
			/* finish with line */
			if (inptr==inbuff) *inptr++ = ch;
			*inptr = '\0';
			strcpy(str,inbuff);
			inptr = inbuff;
			return(DIG_KEY);
		}
		else {
			*inptr = ch;
			*(inptr+1) = '\0';
			digtextp(24,curx,digdata.nvert-digdata.chheight-1,inptr);
			if (inptr < (inbuff+80)) {
				inptr++;
				curx += digdata.chwidth;
			}
		}
	} while (1);
}

#ifdef EMO
#include <time.h>
static void sleep(int sec)
{
	time_t tim = time((time_t *)0)+sec+1;
	while (time((time_t *)0) < tim) /* loop */;
}

main()
{
	char	pr[80];
	float	x,y;
	char	b,ans[80];

	digstart('\0',NULL,1);
	digscale(4.0,4.0,1);
	digclearscreen();
	digorigin(2.0,2.0);

	diginitmouse(0.0,0.0);

	digprompt("type something: ");
	do {
		diggetmouse(ans,&b,&x,&y);
		if (ans[0]) {
			strcpy(pr,"you typed: ");
			strcat(pr,ans);
			digprompt(pr);
			sleep(1);
		}
		switch (b) {
			case 0: digprompt("zero, type something: "); break;
			case 1:	digprompt("one"); break;
			case 2:	digprompt("two"); break;
			case 3:	digprompt("three"); break;
			case 4:	digprompt("four"); break;
			case 5:	digprompt("five"); break;
			case 6:	digprompt("six"); break;
			case 7:	digprompt("seven"); break;
		}
		if (b) digline(20,0.0,0.0,x,y);
	} while (strcmp(ans,"q"));
	digkillmouse();
	digquit(15);
}
#endif
