/* diggtable - dispatch table for device independent graphics routines */

/* Currently supporting:

'o'		Graphics Metafile
'm'		Masscomp 800x600 6 plane
'k','K'		Kyocera laser printer (HP emulation + EXPRESS codes)
'b'		BBC with 'GTERM' terminal emulator
't'		Tektronix 4xxx family
'a'		UCL-ANSI terminal emulator
's'		Sun Console
'w'		WordPerfect .WPG format
'x'		X-Windows with X-View
'X'		X-Windows bare
*/

#include <stdio.h>
#include "SFSCONFG.h"
#include "dig.h"
#include "digtable.h"

/* external declarations */
extern int	meta_params(),meta_open(),meta_outfile(),meta_inter(),
		meta_close(),meta_clear(),meta_polyline(),meta_text(),
		meta_fillrect(),meta_circle(),meta_fcircle(),meta_arc();
extern int	mass_params(),mass_open(),mass_close(),mass_clear(),mass_inter(),
		mass_polyline(),mass_text(),mass_fillrect(),mass_rasterop(),
		mass_circle(),mass_fcircle(),mass_arc(),mass_pointer(),
		mass_mouse(),mass_prompt(),mass_gscale();
extern int	sun_params(),sun_open(),sun_close(),sun_clear(),sun_inter(),
		sun_polyline(),sun_text(),sun_fillrect(),sun_rasterop(),
		sun_pointer(),sun_pause(),
		sun_mouse(),sun_prompt(),sun_gscale();
extern int	kyoc_params(),kyoc_open(),kyoc_outfile(),kyoc_inter(),
		kyoc_close(),kyoc_clear(),kyoc_polyline(),kyoc_text(),
		kyoc_fillrect(),kyoc_circle(),kyoc_fcircle(),kyoc_arc(),
		kyoc_gscale();
extern int	ps_params(),ps_open(),ps_outfile(),ps_inter(),
		ps_close(),ps_clear(),ps_polyline(),ps_text(),
		ps_fillrect(),ps_circle(),ps_fcircle(),
		ps_gscale(),ps_pause();
extern int	bbc_params(),bbc_open(),bbc_inter(),bbc_close(),bbc_clear(),
		bbc_polyline(),bbc_text(),bbc_fillrect(),bbc_rasterop(),
		bbc_pointer(),bbc_mouse(),bbc_prompt(),bbc_gscale();
extern int	tek_params(),tek_open(),tek_inter(),tek_close(),tek_clear(),
		tek_polyline(),tek_text(),tek_fillrect(),tek_pointer(),
		tek_mouse(),tek_prompt();
extern int	ansi_params(),ansi_open(),ansi_inter(),ansi_close(),
		ansi_clear(),ansi_polyline(),ansi_text(),ansi_fillrect(),
		ansi_rasterop(),ansi_pointer(),ansi_mouse(),ansi_prompt(),
		ansi_gscale();
extern int	xdig_params(),xdig_open(),xdig_inter(),xdig_close(),
		xdig_clear(),xdig_polyline(),xdig_text(),xdig_fillrect(),
		xdig_rasterop(),xdig_pointer(),xdig_mouse(),xdig_prompt(),
		xdig_gscale(),xdig_pause();
extern int	x11dig_params(),x11dig_open(),x11dig_inter(),x11dig_close(),
		x11dig_clear(),x11dig_polyline(),x11dig_text(),x11dig_fillrect(),
		x11dig_rasterop(),x11dig_pointer(),x11dig_mouse(),x11dig_prompt(),
		x11dig_gscale(),x11dig_pause();
extern int	pc_params(),pc_open(),pc_close(),pc_clear(),pc_polyline(),
		pc_text(),pc_fillrect(),pc_rasterop(),pc_circle(),pc_fcircle(),
		pc_pointer(),pc_mouse(),pc_gscale();
extern int	vga_params(),vga_open(),vga_inter(),vga_close(),
		vga_clear(),vga_polyline(),vga_text(),vga_fillrect(),
		vga_rasterop(),vga_pointer(),vga_mouse(),vga_prompt(),
		vga_gscale(),vga_pause(),vga_circle(),vga_fcircle();
extern int	wp_params(),wp_outfile(),wp_open(),wp_inter(),wp_close(),
		wp_clear(),wp_polyline(),wp_text(),wp_fillrect(),
		wp_gscale(),wp_pause(),wp_circle(),wp_fcircle();
extern int	bm_params(),bm_outfile(),bm_open(),bm_inter(),bm_close(),
		bm_clear(),bm_polyline(),bm_text(),bm_fillrect(),
		bm_gscale(),bm_pause();
extern int	ep_params(),ep_outfile(),ep_open(),ep_inter(),ep_close(),
		ep_clear(),ep_polyline(),ep_text(),ep_fillrect(),
		ep_gscale(),ep_pause();
extern int	w32p_params(),w32p_open(),w32p_inter(),w32p_close(),
		w32p_clear(),w32p_polyline(),w32p_text(),w32p_fillrect(),
		w32p_circle(),w32p_fcircle(),w32p_gscale(),w32p_pause();
extern int	w32raw_params(),w32raw_open(),w32raw_inter(),w32raw_close(),
		w32raw_clear(),w32raw_polyline(),w32raw_text(),w32raw_fillrect(),
		w32raw_gscale(),w32raw_pause(),w32raw_rasterop();
extern int	svg_params(),svg_outfile(),svg_open(),svg_inter(),svg_close(),
		svg_clear(),svg_polyline(),svg_text(),svg_fillrect(),
		svg_gscale(),svg_pause(),svg_vtext();

/* digtable dispatch structure */
struct digtable_rec digtable[]={
{	/* Graphics Metafile */
	'o',
	meta_params,
	meta_outfile,
	meta_open,
	meta_inter,
	meta_close,
	meta_clear,
	meta_polyline,
	meta_text,
	meta_fillrect,
	NULL,
	meta_circle,
	meta_fcircle,
	meta_arc,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
},
#ifdef EVm
{	/* Masscomp Graphics */
	'm',
	mass_params,
	NULL,
	mass_open,
	mass_inter,
	mass_close,
	mass_clear,
	mass_polyline,
	mass_text,
	mass_fillrect,
	mass_rasterop,
	NULL,
	NULL,
	NULL,
	mass_pointer,
	mass_mouse,
	mass_prompt,
	mass_gscale,
	NULL,
	NULL
},
#endif
#ifdef EVs
{	/* Sun Graphics */
	's',
	sun_params,
	NULL,
	sun_open,
	sun_inter,
	sun_close,
	sun_clear,
	sun_polyline,
	sun_text,
	sun_fillrect,
	sun_rasterop,
	NULL,
	NULL,
	NULL,
	sun_pointer,
	sun_mouse,
	sun_prompt,
	sun_gscale,
	sun_pause,
	NULL
},
#endif
#ifdef EVk
{	/* Kyocera Laser Printer - landscape */
	'k',
	kyoc_params,
	kyoc_outfile,
	kyoc_open,
	kyoc_inter,
	kyoc_close,
	kyoc_clear,
	kyoc_polyline,
	kyoc_text,
	kyoc_fillrect,
	NULL,
	kyoc_circle,
	kyoc_fcircle,
	kyoc_arc,
	NULL,
	NULL,
	NULL,
	kyoc_gscale,
	NULL,
	NULL
},
#endif
#ifdef EVk
{	/* Kyocera Laser Printer - portrait */
	'K',
	kyoc_params,
	kyoc_outfile,
	kyoc_open,
	kyoc_inter,
	kyoc_close,
	kyoc_clear,
	kyoc_polyline,
	kyoc_text,
	kyoc_fillrect,
	NULL,
	kyoc_circle,
	kyoc_fcircle,
	kyoc_arc,
	NULL,
	NULL,
	NULL,
	kyoc_gscale,
	NULL,
	NULL
},
#endif
#ifdef EVp
{	/* Postscript Printer */
	'p',
	ps_params,
	ps_outfile,
	ps_open,
	ps_inter,
	ps_close,
	ps_clear,
	ps_polyline,
	ps_text,
	ps_fillrect,
	NULL,
	ps_circle,
	ps_fcircle,
	NULL,
	NULL,
	NULL,
	NULL,
	ps_gscale,
	ps_pause,
	NULL
},
#endif
#ifdef EVb
{	/* BBC/GTERM */
	'b',
	bbc_params,
	NULL,
	bbc_open,
	bbc_inter,
	bbc_close,
	bbc_clear,
	bbc_polyline,
	bbc_text,
	bbc_fillrect,
	bbc_rasterop,
	NULL,
	NULL,
	NULL,
	bbc_pointer,
	bbc_mouse,
	bbc_prompt,
	bbc_gscale,
	NULL,
	NULL
},
#endif
#ifdef EVtX
{	/* Tektronix */
	't',
	tek_params,
	NULL,
	tek_open,
	tek_inter,
	tek_close,
	tek_clear,
	tek_polyline,
	tek_text,
	tek_fillrect,
	NULL,
	NULL,
	NULL,
	NULL,
	tek_pointer,
	tek_mouse,
	tek_prompt,
	tek_gscale,
	NULL,
	NULL
},
#endif
#ifdef EVa
{	/* UCL/ANSI terminal emulator */
	'a',
	ansi_params,
	NULL,
	ansi_open,
	ansi_inter,
	ansi_close,
	ansi_clear,
	ansi_polyline,
	ansi_text,
	ansi_fillrect,
	ansi_rasterop,
	NULL,
	NULL,
	NULL,
	ansi_pointer,
	ansi_mouse,
	ansi_prompt,
	ansi_gscale,
	NULL,
	NULL
},
#endif
#ifdef EVv
{	/* VGA with GRX library  */
	'v',
	vga_params,
	NULL,
	vga_open,
	vga_inter,
	vga_close,
	vga_clear,
	vga_polyline,
	vga_text,
	vga_fillrect,
	vga_rasterop,
	vga_circle,
	vga_fcircle,
	NULL,
	vga_pointer,
	vga_mouse,
	vga_prompt,
	vga_gscale,
	vga_pause,
	NULL
},
#endif
#ifdef EVw
{	/* WordPerfect .WPG graphics file format  */
	'w',
	wp_params,
	wp_outfile,
	wp_open,
	wp_inter,
	wp_close,
	wp_clear,
	wp_polyline,
	wp_text,
	wp_fillrect,
	NULL,
	wp_circle,
	wp_fcircle,
	NULL,
	NULL,
	NULL,
	NULL,
	wp_gscale,
	wp_pause,
	NULL
},
#endif
#ifdef EVB
{	/* Generic BITMAP output  */
	'B',
	bm_params,
	bm_outfile,
	bm_open,
	bm_inter,
	bm_close,
	bm_clear,
	bm_polyline,
	bm_text,
	bm_fillrect,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	bm_gscale,
	bm_pause,
	NULL
},
#endif
#ifdef EVe
{	/* Epson colour stylus output  */
	'e',
	ep_params,
	ep_outfile,
	ep_open,
	ep_inter,
	ep_close,
	ep_clear,
	ep_polyline,
	ep_text,
	ep_fillrect,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	ep_gscale,
	ep_pause,
	NULL
},
#endif
#ifdef EVx
{	/* DIG X-Windows with X-View */
	'x',
	xdig_params,
	NULL,
	xdig_open,
	xdig_inter,
	xdig_close,
	xdig_clear,
	xdig_polyline,
	xdig_text,
	xdig_fillrect,
	xdig_rasterop,
	NULL,
	NULL,
	NULL,
	xdig_pointer,
	xdig_mouse,
	xdig_prompt,
	xdig_gscale,
	xdig_pause,
	NULL
},
#endif
#ifdef EVX
{	/* DIG X-Windows bare  */
	'X',
	x11dig_params,
	NULL,
	x11dig_open,
	x11dig_inter,
	x11dig_close,
	x11dig_clear,
	x11dig_polyline,
	x11dig_text,
	x11dig_fillrect,
	x11dig_rasterop,
	NULL,
	NULL,
	NULL,
	x11dig_pointer,
	x11dig_mouse,
	x11dig_prompt,
	x11dig_gscale,
	x11dig_pause,
	NULL
},
#endif
#ifdef EVD
{	/* WIN32 Printer Driver */
	'D',
	w32p_params,
	NULL,
	w32p_open,
	w32p_inter,
	w32p_close,
	w32p_clear,
	w32p_polyline,
	w32p_text,
	w32p_fillrect,
	NULL,
	w32p_circle,
	w32p_fcircle,
	NULL,
	NULL,
	NULL,
	NULL,
	w32p_gscale,
	w32p_pause,
	NULL
},
#endif
#ifdef EVW
{	/* WIN32 Raw device */
	'W',
	w32raw_params,
	NULL,
	w32raw_open,
	w32raw_inter,
	w32raw_close,
	w32raw_clear,
	w32raw_polyline,
	w32raw_text,
	w32raw_fillrect,
	w32raw_rasterop,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	w32raw_gscale,
	w32raw_pause,
	NULL
},
#endif
#ifdef EVg
{	/* Scalable Vector Graphics  */
	'g',
	svg_params,
	svg_outfile,
	svg_open,
	svg_inter,
	svg_close,
	svg_clear,
	svg_polyline,
	svg_text,
	svg_fillrect,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	svg_gscale,
	svg_pause,
	svg_vtext
},
#endif
};

int digtablesize=(sizeof(digtable)/sizeof(struct digtable_rec));
