/* gvtxtlen -- return length of vector text */

#include <stdio.h>
#include <math.h>
#include "SFSCONFG.h"
#include "dig.h"
#include "digdata.h"
#include "digtable.h"

#define VFHEIGHT 21	/* height of a capital letter	*/
#define VFYOFF   32	/* added to y coordinates to make positive	*/
#define VFXOFF   16	/* likewise for x	*/
#define VFBASE	  9	/* bottom of a capital letter	*/

#ifdef __STDC__
float  digvtextlen(char  *word,float  height,float  angle,int  prop)
#else
float digvtextlen(word,height,angle,prop)
char	*word;
float	height,angle;
int	prop;
#endif
{
	int letter,wlen;
	short maxwidth;
	double realy,xyscale;
	double cosphi,sinphi;
	double ycos,xsin,xcos;
	char *pc;

	if (!digdata.fontind) digfont("");
	maxwidth = *digdata.fontvec;

	/* calculate drawing constants */
	cosphi = cos (DEG_TO_RADS * angle) ;
	sinphi = sin (DEG_TO_RADS * angle) ;
	xyscale = digdata.aspect * digdata.yscale / digdata.xscale;

	ycos = cosphi/xyscale;
	xsin = sinphi*xyscale;
	realy = height / (VFHEIGHT *  (xsin*sinphi + ycos*cosphi));
	xcos = sqrt((cosphi * realy * cosphi * realy) + (sinphi * realy * sinphi * realy));

#ifdef EMO
fprintf(stderr,"cosphi=%g,sinphi=%g,xyscale=%g,ycos=%g,xsin=%g,realy=%g,xcos=%g\n",
	cosphi,sinphi,xyscale,ycos,xsin,realy,xcos);
#endif

	/* check for special function */
	if (digtable[digdata.select].vtext) {
		wlen = (*digtable[digdata.select].vtext)(-1,0,0,0,0,word,(int)(height*digdata.yscale),prop);
		return((float)(wlen/digdata.xscale));
	}
	else {
		wlen = 0;
		while ((letter = (*word++ & 0377))) {
			pc = digdata.fontvec + digdata.fontind[letter];
			if (pc > digdata.fontvec) {		/* ignore undefined chars	*/
				if (prop) wlen +=  *pc & 0177;
				else wlen += maxwidth;
			}
		}
		return((float)(wlen*xcos));
	}
}

#ifdef EMO
main()
{
	char font[20],word[100];
	float hlen,hlenp;
	float vlen,vlenp;

	fprintf(stderr,"Enter font name: ");
	if (gets(font)==NULL)  exit(0);
	fprintf(stderr,"Enter string: ");
	if (gets(word)==NULL) exit(0);

	digstart('\0',NULL,0) ;
	digscale(3.0,1.0,0);

	digfont(font);

	digclearscreen();

		hlen = digvtextlen(word,0.1,0.0,0);
		digvtext(24,0.5,0.1,word,0.1,0.0,0);
		digbox  (23,0.5,0.1,0.5+hlen,0.2);

		hlenp = digvtextlen(word,0.1,0.0,1);
		digvtext(24,0.5,0.2,word,0.1,0.0,1);
		digbox  (23,0.5,0.2,0.5+hlenp,0.3);

		vlen = digvtextlen(word,0.1,90.0,0);
		digvtext(24,0.5,0.3,word,0.1,90.0,0);
		digbox  (23,0.5,0.3,0.4,0.3+vlen);

		vlenp = digvtextlen(word,0.1,90.0,1);
		digvtext(24,0.7,0.3,word,0.1,90.0,1);
		digbox  (23,0.7,0.3,0.6,0.3+vlenp);

		digflush();

	digwait();
	digend();

		fprintf(stderr,"Horizontal: non-prop length = %f, prop length = %f\n",hlen,hlenp);
		fprintf(stderr,"Vertical: non-prop length = %f, prop length = %f\n",vlen,vlenp);

}
#endif
