/* gwave -- display waveform directly from short buffer */

#include <stdio.h>
#include "SFSCONFG.h"
#include "dig.h"
#include "digdata.h"

#ifdef __STDC__
void   digwave(int  bundle,float  xl,float  yb,float  xr,float  yt,short  *buff,int32  count,int  maxval,int  minval)
#else
void	digwave(bundle,xl,yb,xr,yt,buff,count,maxval,minval)
int	bundle;		/* line style */
float	xl,yb,xr,yt;	/* window location */
short	*buff;		/* buffer of shorts */
int32	count;		/* number of samples */
int	minval,maxval;	/* minimum and maximum values */
#endif
{
	register int	i,j;
	register short	*ptr;
	int	numpel,fend;
	short	val1,val2,val3,val4;
	double	fcount,fstep;
	double	tscale,ascale,xfactor=1.0;
	int	ixl,iyb,ixr,iyt;
	int	ixold,iyold,ix,iy;
	int32	lscale;

	/* convert to pixels */
	ixl = xpix(xl);
	iyb = ypix(yb);
	ixr = xpix(xr);
	iyt = ypix(yt);

	/* calculate time and amplitude scaling */
	if (count<=1)
		tscale= (float)(ixr - ixl);
	else
		tscale= (float)(ixr - ixl) / (count-1);
	ascale= (float)(iyt - iyb) / (maxval - minval);
	lscale = (int32)(ascale * 65536.0);

	/* calculate number of x-axis pixels in window */
	numpel = (ixr - ixl);
	if (digdata.device=='b') {
		numpel = numpel / 2;
		xfactor = 2.0;
	}
	else if (digdata.device=='o') {
		numpel=(numpel * 3) / 20; /* ratio to best printing device */
		xfactor = 20.0/3.0;
	}
	fstep = count * 1.0 / numpel;

	/* do straight, or with compression */
	ixold=ixl;
	iyold=(int)((buff[0] - minval) * ascale + iyb);

	if (fstep < 4.0) {
		for (i=1;i<count;i++) {
			ix=(int)(i * tscale + ixl);
			iy=(int)((buff[i] - minval) * ascale + iyb);
			if (iy > iyt) iy=iyt;
			if (iy < iyb) iy=iyb;
			diglinep(bundle,ixold,iyold,ix,iy);
			ixold=ix;
			iyold=iy;
		}
	}
	else {
		/* step through waveform in chunks */
		fcount=0;
		for (i=0;i<numpel;i++) {
			j=(int)fcount;
			val1=val2=val3=buff[j];
			ptr = &buff[j];
			fend=(int)(fcount+fstep);
			for (j=(int)fcount;j<=fend;j++,ptr++) {
				if (*ptr>val2) val2 = *ptr;
				if (*ptr<val3) val3 = *ptr;
			}
			val4=buff[j-1];
			fcount += fstep;

			/* plot to first point */
			ix=(int)((i*fstep*tscale) + ixl);

			/* draw vertical bar from max to min */
			iyold=(((val2 - minval) * lscale) >> 16) + iyb;
			if (iyold > iyt) iyold=iyt;
			if (iyold < iyb) iyold=iyb;
			iy   =(((val3 - minval) * lscale) >> 16) + iyb;
			if (iy > iyt) iy=iyt;
			if (iy < iyb) iy=iyb;
			diglinep(bundle,ix,iyold,ix,iy);

		}
	}
	digflush();
}

#ifdef EMO
main()
{
	short	buff[1000],rbuff[10000];
	double	sin();
	int	i;

	for (i=0;i<1000;i++) buff[i] = (short)(1000 * sin((double)i*0.05));
	for (i=0;i<10000;i++) rbuff[i] = (short)(rand()%2000 - 1000);

	digstart(DIG_DEFAULT_TERM,NULL,0) ;
	digscale (4.0,4.0,1);
	digorigin(2.0,2.0);
	digwave(22,-2.0,-1.0,2.0,1.0,rbuff,10000,1000,-1000);

	/* Draw the clip limit	*/
	digfillbox(0,-1.0,-1.0,1.0,1.0);
	digline(20,-1.0,-1.0,-1.0,1.0);
	digline(20,-1.0,1.0,1.0,1.0);
	digline(20,1.0,1.0,1.0,-1.0);
	digline(20,1.0,-1.0,-1.0,-1.0);

	/* Draw the sine in clipped box */
	digclip(-1.0,-1.0,1.0,1.0);
	digwave(21,-2.0,-1.0,2.0,1.0,buff,1000,1000,-1000);
	digquit(15);
}
#endif
