#include <stdio.h>
#include <string.h>

#define XLIB_NT
#include "windows.h"
#include "xnt.h"

static char *text  = "here";

/************************************************

MAIN ROUTINE

************************************************/
void
main(argc, argv)
int argc;
char *argv[];
{
Display      *display;
Window       window, root;
int          screen;
unsigned int width = 400, height = 200;
int          x_pos = 100, y_pos = 100;
long int     black, white;
XEvent       event;
int          done = 0;
GC           gc;
XGCValues    gc_values;
int          i, n_windows = 1;

  if ( (display=XOpenDisplay("")) == NULL )
	{
	fprintf(stderr,"Error opening display\n");
        exit(-1);
	}

  screen = DefaultScreen(display);
  root   = RootWindow(display, screen);

  black = BlackPixel(display, screen);
  white = WhitePixel(display, screen);

  window = XCreateSimpleWindow(display, root,
			     0, 0, width, height, 2,
			     black, black);
  XSelectInput(display, window, 
		   ExposureMask | KeyPressMask |
		   ButtonPressMask | StructureNotifyMask);
  XMapWindow(display, window);

  gc = XCreateGC(display, window, (long)0, &gc_values);
  XSetForeground(display, gc, white);
  XClearWindow(display, window);
  XDrawString(display, window, gc, x_pos, y_pos,
		      text, strlen(text));

  while(!done)
    {
    XNextEvent(display, &event);
    switch(event.type)
      {
      case Expose:
        window = event.xexpose.window;
     	XClearWindow(display, window);
	XDrawString(display, window, gc, x_pos, y_pos,
		      text, strlen(text));
	break;

      case ConfigureNotify:
	break;

      case ButtonPress:
	window = event.xbutton.window;
/*	XClearWindow(display, window);*/
	x_pos = event.xbutton.x;
	y_pos = event.xbutton.y;
	XDrawString(display, window, gc, x_pos, y_pos,
		    text, strlen(text));
        break;

      case KeyPress:
        done = 1;
        break;

      default:
	break;
      }
    }
 exit(1);
}
