/*  digitemCO -- coefficient item display  */

/* version 1.0 - November 1987
	-SFS release
*/

#include <stdio.h>
#include <fcntl.h>
#include "sfs.h"
#include "dig.h"
#include "digdata.h"
#include "digitem.h"

#define	DBRANGE	40.0		/* dB range displayed */
#define SPHEIGHT 10		/* spectrum height in characters */

#ifdef __STDC__
int    digitemCO(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,struct co_rec *buff,double    start,double   stop,int  flags)
#else
int digitemCO(bundles,xl,yb,xr,yt,item,buff,start,stop,flags)
int32		bundles;	/* colours for graph */
float		xl,yb,xr,yt;	/* co-ords of box */
struct item_header *item;	/* data definition */
struct co_rec	*buff;		/* data buffer */
double		start,stop;     /* start and stop times	*/
int	 	flags;		/* possible options on display */
#endif
{
	register  int   i,j;	/* index variable */
	int		x,y,z,oldy,oldz;
	double		s,t;
	double		maxamp,minamp;
	int		lsize,fsize,tsize;
	double		zscale;
	short		*xtop;
	char		str[12];
	char		*labels=NULL;

	/* sort out bundles */
	digitbundle(bundles);

	/* init box */
	digitbox(xl,yb,xr,yt,start,stop,flags);
	xl += digitab.ixoff/digdata.xscale;
	yt = yval(digitab.iyt);

	/* calculate y scaling */
	fsize = (item->datasize*item->framesize-sfsstruct[CO_TYPE])/sizeof(float);
	/* get max and min values */
	if (!(flags & DIGITEMFIX)) {
		if ((labels=params(item->params,"labels",NULL))==NULL) {
			digitab.lo = param(item->params,"minf",0.0);
			digitab.hi = param(item->params,"maxf",0.5/item->frameduration);
		}
		lsize = 0;
		tsize = fsize;
	}
	else {
		if ((labels=params(item->params,"labels",NULL))==NULL) {
			minamp = param(item->params,"minf",0.0);
			maxamp = param(item->params,"maxf",0.5/item->frameduration);
			lsize = (int)(((digitab.lo-minamp) * fsize) / (maxamp-minamp));
			tsize = (int)(((digitab.hi-minamp) * fsize) / (maxamp-minamp));
			if (lsize < 0) lsize=0;
			if (tsize < 0) tsize=1;
			if (lsize > fsize) lsize=fsize-1;
			if (tsize > fsize) tsize=fsize;
			digitab.lo = (lsize*(maxamp-minamp))/fsize + minamp;
			digitab.hi = (tsize*(maxamp-minamp))/fsize + minamp;
		}
		else {
			lsize = (int)digitab.lo;
			tsize = (int)digitab.hi;
			if (lsize < 0) lsize=0;
			if (tsize < 0) tsize=1;
			if (lsize > fsize) lsize=fsize-1;
			if (tsize > fsize) tsize=fsize;
		}
	}
	digitab.scaley = ((double)(digitab.iyt-digitab.iyb))/(tsize-lsize);

	/* write y-axis */
	if (labels==NULL) {
		digitemfreq(bundles,digitab.iyb,digitab.iyt,digitab.lo,digitab.hi,1);
		/* write axis label */
		y = (digitab.iyt + digitab.iyb - digdata.chheight)/2;
		digtextp(digitab.dbun,digitab.ixl+3,digitab.iytitle,"Hz");
	}
	else
		digitemlabel(bundles,digitab.iyb,digitab.iyt,labels,lsize,tsize-lsize+1);

	/* get line-removal buffer */
	xtop = (short *)calloc(fsize,sizeof(short));
	for (j=0;j<fsize;j++) xtop[j]=digitab.ixl+digitab.ixoff;

	/* calculate z scaling */
	maxamp = -(1.0E6);
	for (i=0;i<item->numframes;i++) for (j=lsize;j<tsize;j++) {
		if (buff[i].data[j] > maxamp) maxamp = buff[i].data[j];
	}
	minamp = maxamp - DBRANGE;
	zscale = SPHEIGHT * digdata.chwidth / DBRANGE;
	if (labels==NULL) {
		sprintf(str,"Hz (%ddB)",(int)maxamp);
		y = (digitab.iyt+digitab.iyb-3*digdata.chheight)/2;
		digtextp(digitab.lbun,digitab.ixl+3,digitab.iytitle,str);
	}

	/* index data and plot spectra */
	s = item->offset-start;
	digclippush();
	digclip(xl,yb,xr,yt);
	for (i=0;i<item->numframes;i++) {

		/* find time of frame */
		t = buff[i].posn*item->frameduration+s;

		/* calculate x-value for display */
		x = (int)(digitab.ixl + digitab.ixoff + t*digitab.scalex*digdata.xscale);

		/* end at last plottable record */
		if (x > digitab.ixr-digdata.chwidth) break;

		/* check x-value lies within box */
		if ((x >= (digitab.ixl+digitab.ixoff)) && (x < digitab.ixr)) {
			oldy = digitab.iyb;
			if (lsize > 0)
				oldz = (int)((buff[i].data[lsize-1]-minamp)*zscale);
			else
				oldz = (int)((buff[i].data[0]-minamp)*zscale);
			if ((x+oldz)>=xtop[0]) xtop[0]=x+oldz;
			/* plot spectral data */
			for (j=lsize;j<tsize;j++) {
				y = (int)(digitab.iyb + (j-lsize)*digitab.scaley);
				z = (int)((buff[i].data[j]-minamp)*zscale);
				if (z < 0) z=0;
				if (((x+oldz)>=xtop[j-1]) && ((x+z)>=xtop[j])) {
					diglinep(digitab.gbun,x+oldz,oldy,x+z,y);
					xtop[j]=x+z;
				}
				oldy=y;
				oldz=z;
			}
			/* plot off top in part scales */
			if (tsize < fsize) {
				y = (int)(digitab.iyb + (j-lsize)*digitab.scaley);
				z = (int)((buff[i].data[j]-minamp)*zscale);
				if (z < 0) z=0;
				if (((x+oldz)>=xtop[j-1]) && ((x+z)>=xtop[j])) {
					diglinep(digitab.gbun,x+oldz,oldy,x+z,y);
					xtop[j]=x+z;
				}
			}
			/* plot zero amp reference marks */
			diglinep(digitab.dbun,x,digitab.iyt,x,digitab.iyt-digdata.chheight/2);
			diglinep(digitab.dbun,x,digitab.iyb,x,digitab.iyb+digdata.chheight/2);
		}

	}
	digclippop();
	free(xtop);

	/* draw title if required */
	digititle(item,flags);

	/* that's it */
	digflush();
	return(0);
}

#ifdef	EMO
char	*progname="digitemCO";
main(argc,argv)
int	argc;
char	*argv[];
{
	struct		item_header item;          /* data definition */
	struct co_rec	*buff;                     /* data buffer     */

	/* choose between laser printer or terminal, 'k' indicates   */
	/* the laser printer, '\0' indicates a terminal.                */

	if (strcmp(argv[1],"-p") ==0) {
		digstart ('k',NULL,1);
	  	getitem(argv[2],CO_TYPE,"*",&item,&buff);
	}
	else {
		digstart ('\0',NULL,1);
		getitem(argv[1],CO_TYPE,"*",&item,&buff);
	}

	/* set the scale */
	digscale (10.0,10.0,0);

	/* clear the screen for the display */
	digclearscreen();

	/* call digitemtime for the timescale */
	digitemtime(23,0.0,9.0,10.0,9.5,0.0,1.0,1);

	/* call digitemCO for the CO data */
	digitemCO(20,0.0,6.0,10.0,9.0,&item,buff,0.0,1.0,1);

	digitemCO(20,0.0,3.0,10.0,6.0,&item,buff,0.5,1.5,3);

	item.offset=0.1;
	digitemCO(20,0.0,0.0,10.0,3.0,&item,buff,0.0,1.0,3);

	digend();
	exit(0);
}
#endif


