/*  digitemFM ---- formant display  */

/* version 1.0 - November 1987
	-SFS release
*/

#include <stdio.h>
#include <fcntl.h>
#include "sfs.h"
#include "dig.h"
#include "digdata.h"
#include "digitem.h"

extern int	digit_ygrid[100];
extern int	digit_nygrid;
extern int	digit_xgrid[100];
extern int	digit_nxgrid;

#ifdef __STDC__
int    digitemFM(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,struct fm_rec *buff,double    start,double   stop,int  flags)
#else
int digitemFM(bundles,xl,yb,xr,yt,item,buff,start,stop,flags)
int32		bundles;	/* colours for graph */
float		xl,yb,xr,yt;	/* co-ords of box */
struct item_header *item;	/* data definition */
struct fm_rec	*buff;		/* data buffer */
double		start,stop;     /* start and stop times	*/
int	 	flags;		/* possible options on display */
#endif
{
	register  int   i,j;	/* index variable */
	int		x,y;
	double		s,t;
	static	char	*symbol[9]={"1","2","3","4","5","6","7","8","9"};

	/* sort out bundles */
	digitbundle(bundles);

	/* init box */
	digitbox(xl,yb,xr,yt,start,stop,flags);
	xl += digitab.ixoff/digdata.xscale;

	/* write axis label */
	y = (digitab.iyt + digitab.iyb - digdata.chheight)/2;
	digtextp(digitab.lbun,digitab.ixl+3,digitab.iytitle,"Hz");

	/* calculate y scaling */
	digitab.scaley = (5000.0)/(digitab.iyt-digitab.iyb);

	/* plot y-axis */
	if (!(flags & DIGITEMFIX)) {
		digitab.lo = 0.0;
		digitab.hi = 5000.0;
	}
	digitemfreq(bundles,digitab.iyb,digitab.iyt,digitab.lo,digitab.hi,1);

	/* draw grid, if required */
	if (flags & DIGITEMYGRID) {
		for (i=0;i<digit_nygrid;i++)
			diglinep(81,digitab.ixl+digitab.ixoff,digit_ygrid[i],digitab.ixr,digit_ygrid[i]);
	}
	if (flags & DIGITEMXGRID) {
		for (i=0;i<digit_nxgrid;i++)
			diglinep(81,digit_xgrid[i],digitab.iyb,digit_xgrid[i],digitab.iyt);
	}

	/* index data and plot tx marks */
	s = item->offset-start;
	for (i=0;i<item->numframes;i++) {

		/* find time of frame */
		t = buff[i].posn*item->frameduration+s;

		/* calculate x-value for display */
		x = (int)(digitab.ixl + digitab.ixoff + t*digitab.scalex*digdata.xscale);

		/* end at last tx plottable */
		if (x > digitab.ixr-digdata.chwidth) break;

		/* check x-value lies within box */
		if ((x >= (digitab.ixl+digitab.ixoff)) && (x < digitab.ixr)) {
			/* plot frequency data */
			for (j=0;j<buff[i].npeaks;j++) {
				y = (int)(digitab.iyb + buff[i].formant[j].freq/digitab.scaley);
				if ((y > digitab.iyb) && (y <= digitab.iyt-digdata.chheight))
					digtextp(digitab.gbun,x,y,symbol[j]);
			}
		}

	}

	/* draw title if required */
	digititle(item,flags);

	/* that's it */
	digflush();
	return(0);
}

#ifdef	EMO
char	*progname="digitemFM";
main(argc,argv)
int	argc;
char	*argv[];
{
	struct		item_header item;          /* data definition */
	struct fm_rec	*buff;                     /* data buffer     */

	/* choose between laser printer or terminal, 'k' indicates   */
	/* the laser printer, '\0' indicates a terminal.                */

	if (strcmp(argv[1],"-p") ==0) {
		digstart ('k',NULL,1);
	  	getitem(argv[2],FM_TYPE,"*",&item,&buff);
	}
	else {
		digstart ('\0',NULL,1);
		getitem(argv[1],FM_TYPE,"*",&item,&buff);
	}

	/* set the scale */
	digscale (10.0,10.0,0);

	/* clear the screen for the display */
	digclearscreen();

	/* call digitemtime for the timescale */
	digitemtime(23,0.0,9.0,10.0,9.5,0.0,1.0,1);

	/* call digitemFM for the FM data */
	digitemFM(20,0.0,6.0,10.0,9.0,&item,buff,0.0,1.0,1);

	digitemFM(20,0.0,3.0,10.0,6.0,&item,buff,0.5,1.5,3);

	item.offset=0.1;
	digitemFM(20,0.0,0.0,10.0,3.0,&item,buff,0.0,1.0,3);

	digend();
	exit(0);
}
#endif


