/* digitutil -- utility routines for dig item routines */

#include <stdio.h>
#include <fcntl.h>
#include "sfs.h"
#include "dig.h"
#include "digdata.h"
#include "digitem.h"
extern char	*sfslabel[];

/* sort out bundles */
void digitbundle(bundles)
int32	bundles;
{
	/* determine bundles */
	digitab.gbun = bundles % 100;
	if (digitab.gbun==0) digitab.gbun=DEFBUN;
	digitab.lbun = (bundles % 10000) / 100;
	if (digitab.lbun==0) digitab.lbun=DEFBUN;
	digitab.dbun = (bundles % 1000000) / 10000;
	if (digitab.dbun==0) digitab.dbun=DEFBUN;
	digitab.abun = (bundles % 100000000) / 1000000;
	if (digitab.abun==0) digitab.abun=DEFBUN;
}

/* sort out box co-ordinates and init box */
#ifdef __STDC__
void   digitbox(float  xl,float  yb,float  xr,float  yt,double start,double stop,int   flags)
#else
void digitbox(xl,yb,xr,yt,start,stop,flags)
float	xl,yb,xr,yt;
double	start,stop;
int	flags;
#endif
{
	/* get pixel coordinates of original box */
	digitab.ixl = xpix(xl);
	digitab.iyb = ypix(yb);
	digitab.ixr = xpix(xr);
	digitab.iyt = ypix(yt);
	digitab.iytitle = digitab.iyt - digdata.chheight - 3;

	/* clear box if required */
	if (!(flags & DIGITEMOVERLAY)) digfillbox(0,xl,yb,xr,yt);

	/* draw box if required */
	if (flags & DIGITEMBOX) digbox(digitab.abun,xl,yb,xr,yt);

	/* determine size of x-axis offset */
	if (!digdata.setup) return;
	digitab.ixoff = AXCHAR * digdata.chwidth + 3;
	xl += digitab.ixoff/digdata.xscale;

	/* draw y-axis */
	diglinep(digitab.abun,digitab.ixl+digitab.ixoff,digitab.iyb,digitab.ixl+digitab.ixoff,digitab.iyt);

	/* adjust top of require gap for title */
	if (flags & DIGITEMGAP) {
		digitab.iyt -= digdata.chheight+4;
		digitab.iytitle = digitab.iyt+1;
	}

	/* get scale factor */
	digitab.scalex = (xr-xl)/(stop-start);
}

/* draw item title */
void digititle(item,flags)
struct item_header *item;
int	flags;
{
	char	title[256],*p;
	float	digtextlen();
	int		rlim=digitab.ixr;
	int		i,len;

	/* draw item number */
	if (flags & DIGITEMLABEL) {
		if (digitab.label)
			strncpy(title,digitab.label,255);
		else
			sprintf(title,"%s.%02d",sfslabel[item->datatype],item->subtype);
		rlim = (int)(digitab.ixr-(int)(0.5+digtextlen(title)*digdata.xscale))-3;
		if (rlim > digitab.ixoff)
			digtextp(digitab.lbun,rlim,digitab.iytitle,title);
		else
			rlim=digitab.ixr;
	}

	/* draw title */
	if (flags & DIGITEMTITLE) {
		if (digitab.title)
			strncpy(title,digitab.title,255);
		else if ((p=lab_gettext(lab_store(item)))==NULL)
			strncpy(title,item->history,255);
		else
			strncpy(title,p,255);
		title[255]='\0';
		len=(int)(0.5+digtextlen(title)*digdata.xscale);
		if ((digitab.ixoff+3+len) >= rlim) {
			i = (strlen(title)*(rlim-digitab.ixoff-3))/len;
			if (i > 5)
				strcpy(title+i-4," ...");
			else if (i > 0)
				title[i]='\0';
		}
		digtextp(digitab.lbun,digitab.ixl+digitab.ixoff+3,digitab.iytitle,title);
	}

}
