/* form.c -- estimate formant positions in signal window */

/*
 * (c) 1994 Mark Huckvale
 * Search Systems Ltd
 * 52-54 High Holborn
 * London WC1E 6BT
 * Tel. 071-430 1685
 */

#include <stdio.h>
#include <math.h>
#ifndef PI
#define PI        3.14159265358979323846
#endif
#include "complex.h"
#include "window.h"
#include "lsys.h"
#include "root.h"
#include "lpca.h"
#include "form.h"

/* estimate formant parameters */
void FormantEstimate(x,len,smr,flist,fcount)
float *x;
int len;
double smr;
struct formant_rec *flist;
int *fcount;
{
	int		ncoeff;
	LTIState	osys;
	double		pe;
	COMPLEX		rp[MAXLTISIZE];
	COMPLEX		rt[MAXLTISIZE];
	int		i;

	/* pre-emphasise and window signal */
	PreEmphasis(x,len);
	Hamming(x,len);

	/* perform LPC */
	ncoeff = 2 + (int)(smr/1000);

	if (LPCAutocorrelation(x,len,ncoeff,&osys,&pe)==0) {

		/* make (complex) polynomial from predictor coefficients */
		rp[0] = CMake(1.0,0.0);
		for (i=1;i<=osys.nb;i++) 
			rp[i] = CMake(osys.b[i],0.0);

		/* root solve */
		AllRoots(rp,osys.nb,rt);

		/* put formant frequencies and bandwidths into list */
		*fcount=0;
		for (i=1;i<=osys.nb;i++) if (rt[i].im > 0) {
			if (*fcount < MAXFORMANT) *fcount = *fcount + 1;
			/* look at complex poles in top half of unit circle only */
			flist[*fcount].frequency = CArg(rt[i])*smr/(2*PI);
			flist[*fcount].bandwidth = -log(CMag(rt[i]))*smr/PI;
			if (flist[*fcount].bandwidth < 0) {
				/* take reciprocal of root 
				  to reflect inside unit circle */
				rt[i] = CDiv(CMake(1.0,0.0),rt[i]);
				flist[*fcount].bandwidth = -log(CMag(rt[i]))*smr/PI;
			}
			/* get amplitude from LPC spectrum */
			flist[*fcount].amplitude = 20*log10(LTISystemResponse(&osys,flist[*fcount].frequency/smr));
		}
	}
	else
		*fcount = 0;
}
