/* lpccov.c -- LPC by Covariance routine */
/* from old FORTRAN routine COVAR.F - provenance unknown! */

/*
 * Mark Huckvale - University College London
 *
 * October 2002
 */

#include <stdio.h>
#include <math.h>
#include "complex.h"
#include "lsys.h"
#include "lpccov.h"

int LPCCovariance(float *x,int n,int order,LTIState *ltis,double *pe)
/* windowed input signal */
/* # samples in x */
/* predictor order required */
/* returned predictor coefficients */
/* returned predictor error */
			/* returns 0=OK, 1=zero power, 2=fail */
{
	double	cc[MAXORDER+1];		/* covariances */
	double	a[MAXORDER+1];		/* predictor coefficients */
	double	rc[MAXORDER+1];		/* reflection coefficients */
	double	alpha;
	double	beta[MAXORDER+1];
	double	b[MAXORDER*MAXORDER];
	int		i,j,k;			/* loop counters */
	int		retcode=0;
	int		m,mt,msub;
	double	gam,sum;

	/* check */
	if (order > MAXORDER) {
		order = MAXORDER;
		retcode=2;
	}
	m = order;
	mt = (m*(order+1))/2;

	/* set up */
	for (j=1;j<=mt;j++) b[j]=0;
	for (j=1;j<=order;j++) {
		a[j]=0;
		rc[j]=0;
		cc[j]=0;
		beta[j]=0;
	}
	alpha = 0;
	cc[1] = 0;
	cc[2] = 0;
	for (i=order;i<n;i++) {
		alpha += (double)(x[i] * x[i]);
		cc[1] += (double)(x[i] * x[i-1]);
		cc[2] += (double)(x[i-1] * x[i-1]);
	}
	b[1] = 1;
	beta[1] = cc[2];
	rc[1] = -cc[1]/cc[2];
	a[1] = 1;
	a[2] = rc[1];
	alpha += rc[1]*cc[1];

	/* main loop */
	for (i=2;i<=m;i++) {

		/* get covariance coefficients */
		for (j=0;j<i;j++)
			cc[i+1-j] = cc[i-j] +
						(double)(x[order-i]*x[order-i+j]) -
						(double)(x[n-i]*x[n-i+j]);

		cc[1]=0;
		for (j=order;j<n;j++) cc[1] += (double)(x[j-i]*x[j]);

		/* calculate b matrix */
		msub = (i*i-i)/2;
		b[msub+i] = 1;

		for (j=1;j<=i-1;j++) {
			int isub=(j*j-j)/2;

			if (beta[j] <= 0) return(2);

			gam = 0;
			for (k=1;k<=j;k++) gam += cc[k+1] * b[isub+k];
			gam /= beta[j];

			for (k=1;k<=j;k++) b[msub+k] -= gam * b[isub+k];
		}

		/* calculate beta matrix */
		beta[i] = 0;
		for (j=1;j<=i;j++) beta[i] += cc[j+1] * b[msub+j];
		if (beta[i] <= 0) return(2);

		/* calculate reflection coefficient */
		sum = 0;
		for (j=1;j<=i;j++) 	sum += cc[j]*a[j];
		rc[i] = -sum/beta[i];

		/* calculate next autoregressive coefficient */
		for (j=2;j<=i;j++) a[j] += rc[i]*b[msub+j-1];
		a[i+1] = rc[i];

		/* reduce energy by prediction */
		alpha -= rc[i]*rc[i]*beta[i];

		/* check for no signal */
		if (alpha <= 0) return(1);
	}

	/* return residual energy */
	*pe = alpha;

	/* copy into LTI System */
	LTISystemClear(ltis);
	ltis->na = 0;
	ltis->a[0] = 1.0;
	ltis->nb = order;
	for (i=1;i<=order;i++)
		ltis->b[i] = a[i+1];

	return(retcode);
}

#ifdef EMO
#define WINDOWSIZE 32
#define NCOEFF 4
#define C1	0.16
#define C2	-0.12
#define C3	0.08
#define C4	-0.04
main()
{
	float	iwin[NCOEFF+WINDOWSIZE+1];
	LTIState osys;
	double	res;
	int	i,code;

	/* make a test signal from recursive filter */
	iwin[1] = 0;
	iwin[2] = 0;
	iwin[3] = 0;
	iwin[4] = 0;
	iwin[5] = (float)0.75;		/* put in pulse of power sqr(0.75) */
	for (i=6;i<=WINDOWSIZE+NCOEFF;i++)
		iwin[i] = (float)(-C1 * iwin[i-1] - C2 * iwin[i-2] -
				C3 * iwin[i-3] - C4 * iwin[i-4]);

	printf("iwin=");
	for (i=1;i<=WINDOWSIZE+NCOEFF;i++) printf("%g,",iwin[i]);
	printf("\n");

	/* do LPC analysis */
	if ((code=LPCCovariance(iwin+1,WINDOWSIZE+NCOEFF,NCOEFF,&osys,&res))==0) {
		printf("Predictor coefficients:\n");
		for (i=1;i<=NCOEFF;i++)
			printf("%d = %g\n",i,osys.b[i]);
		printf("Residual Power=%g\n",res);
	}
	else
		printf("LPCCovariance returns code %d\n",code);

}
#endif
