/* param -- decode parameter from string */

/* m.a. huckvale - november 1986 */

/*--------------------------------------------------------------------------*/
/**MAN
.TH PARAM SFS3 UCL SFS
.SH NAME
param, params - decode parameter definition out of string
.SH SYNOPSIS
.nf

double  \fBparam\fR(string,parameter,default)
char    *string;
char    *parameter;
double  default;

char    *\fBparams\fR(string,parameter,default)
char    *string;
char    *parameter;
char    *default;

.fi
.SH DESCRIPTION
.I param
provides a convenient mechanism for extracting parameters from item histories and parameter lists.
The routine is given the address of the string, the name of the parameter and a default value.
If the routine finds the substring "<parameter>=" in "string" then it returns the floating point value
of the following number.  If the substring is not found, the default value is returned.
If the substring "<parameter>" is found, the value 1.0 is returned.  Valid parameter names begin with
an alphabetic character.  Valid separator characters are: " ", ",", ";", "(", & ")".
.PP
Example calls might be:
.nf
	sampfreq = param(item.history,"freq",12800.0);
or
	linkflag = param(item.history,"linked",0.0);
.fi
.PP
.I params
operates in exactly the same way as 
.I param
except: (i) if the substring "<parameter>=" is found, the string delimited by the following separator
is returned; (ii) if the substring is not found, the default value - a pointer to char - is returned;
(iii) if the substring "<parameter>" is found, that very substring is returned;(iv) valid separators
do not include whitespace.
.PP 
An example call might be:
.nf
	match = params(item.history,"type",NULL);

.SH VERSION/AUTHOR
1.0 - Mark Huckvale
*/
/*--------------------------------------------------------------------------*/

#include "SFSCONFG.h"
#include <ctype.h>
#include "sfs.h"

#define isseparator(c)	((c==' ')||(c==',')||(c==';')||(c=='(')||(c==')'))

double	param(str,par,def)
char	*str,*par;
double	def;
{
	int	i,flag=0;
	char	*endstr;
	int	lenpar;
	double	atof();

	endstr = str + strlen(str) - strlen(par);
	lenpar = strlen(par);
	while (!flag && (str <= endstr)) {
		if (isalpha(*str)) {
			/* beginning of word - check for match */
			flag=1;
			for (i=0;(flag && (i<lenpar));i++) if (str[i] != par[i]) flag=0;
			if (isdigit(str[i]) || isalpha(str[i])) flag=0;
		}
		/* if not found - skip to next word */
		if (!flag) {
			while (!isseparator(*str) && (str <= endstr)) str++;
			while (!isalpha(*str) && (str <= endstr)) str++;
		}
	}
	if (!flag) {
		return(def);
	}
	else {
		str += lenpar;
		if (*str != '=') {
			return(1.0);
		}
		else {
			return(atof(++str));
		}
	}
}
