/* sfschannel.c -- open an output channel to a temporary file */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <malloc.h>
#include "sfs.h"
#include "sfsdata.h"

int sfschannel(filename,item)
const char	*filename;
struct item_header *item;
{
	int	fid;
	char	ofilename[SFSMAXFILENAME];
	char	*p,*e;
	struct stat	fst;

	strcpy(ofilename,filename);
	e = &ofilename[strlen(ofilename)-1];
	p = e;
#ifdef DOS
	while ((p > ofilename) && (*p != '/') && (*p != '\\')) p--;
	if ((e-p) >= 2)
		*(p+2)='\0';
	strcat(ofilename,"XXXXXX");
#else
	while ((p > ofilename) && (*p != '/')) p--;
	if ((e-p) >= 7)
		*(p+7)='\0';
	strcat(ofilename,".XXXXXX");
#endif

#ifdef IAG
	printf("outfile='%s'\n",ofilename);
#endif

	/* get status for original file */
	if (stat(filename,&fst) != 0) return(-1);

	/* open output file */
	mktemp(ofilename);
#if defined(DOS)||defined(WIN32)
	if ((fid=open(ofilename,O_RDWR | O_CREAT | O_BINARY | O_TRUNC,fst.st_mode)) < 0)
#else
	if ((fid=open(ofilename,O_RDWR | O_CREAT,fst.st_mode)) < 0)
#endif
		return(-1);

	/* check # files */
	if (fid >= MAXFILES) {
		close(fid);
		return(-1);
	}

	/* initialise sfsdata */
	if (sfsdata[fid]==NULL) {
		if ((sfsdata[fid]=(struct sfsdata *)malloc(sizeof(struct sfsdata)))==NULL) {
			close(fid);
			return(-1);
		}
	}
	sfsdata[fid]->mode=SFSWRITE;
	strcpy(sfsdata[fid]->filename,filename);
	strcpy(sfsdata[fid]->ofilename,ofilename);
	sfsdata[fid]->item = *item;
	sfsdata[fid]->item.numframes = 0;
	sfsdata[fid]->item.length = 0;
	sfsdata[fid]->datastart=lseek(fid,0L,1);
	sfsdata[fid]->currpos=sfsdata[fid]->datastart;
	sfsdata[fid]->start=0;
	sfsdata[fid]->numf=0;

	/* return id */
	return(fid);
}

#ifdef IAG
main()
{
	int	code;
	char	filename[80];
	struct item_header item;

	for (;;) {
		printf("Enter filename : ");
		fflush(stdout);
		scanf("%s",filename);
		sfsheader(&item,SP_TYPE,0,2,1,0.0001,0.0,1,0,0);
		code = sfschannel(filename,&item);
		if (code < 0)
			printf("could not open channel\n");
		else {
			printf("channel opened\n");
			close(code);
		}
	}
}
#endif
