/* sfssun4swap -- convert item header to sun4 format */

/* version 1.0 - August 1989 */

#include "SFSCONFG.h"
#include <stdio.h>
#include "sfs.h"

#ifdef IAG
/* definition of speech database item header */
struct item_header {
	char	history[256];	/* processing history */
	char	params[128];	/* special processing parameters */
	int32	processdate;	/* processing date */
	int32	datatype;	/* data type: speech, lx, etc */
	int32	subtype;	/* data sub-type: natural, synthetic, etc */
	int32	floating;	/* fixed or floating data */
	int32	datasize;	/* data item size (bytes) */
	int32	framesize;	/* no. items in time frame */
	int32	numframes;	/* no. frames in data */
	int32	length;		/* overall length (bytes) */
/* THESE ARE THE BUGGERS: */
	double	frameduration;	/* time interval duration (s) */
	double	offset;		/* cumulative time offset */
	int32	datapresent;	/* data present 1=yes,0=no */
/* - moved by SUN compiler */
	char	comment[20];	/* data set comment */
	int32	windowsize;	/* size of analysis window in samples */
	int32	overlap;	/* size of analysis overlap in samples */
	int32	lxsync;		/* flag :larynx syncronous=1,fixed frame=0 */
	char	spare[40];	/* space for expansion */
	int32	machine;	/* machine code: 0=68000, 1=8086 */
};
#endif

#if SFS_SWAP_HEADER

/*	double				double
	int32		becomes		double
	double				int32	     */

#define	iLONGPOSN 106
#define iDOUBONEPOSN 107
#define iDOUBTWOPOSN 108

void sun4swap(head)
int32	*head;
{
	register int32 temp;

	/* convert 68000 to sun4 */
	temp = *(head+iLONGPOSN);
	*(head+iLONGPOSN) = *(head+iDOUBONEPOSN);
	*(head+iDOUBONEPOSN) = *(head+iDOUBTWOPOSN);
	*(head+iDOUBTWOPOSN) = temp;
}

/*	double				double
	double		becomes		int32
	int32				double		 */

#define oDOUBONEPOSN 106
#define oDOUBTWOPOSN 107
#define	oLONGPOSN 108

void sun4unswap(head)
int32	*head;
{
	register int32 temp;

	/* convert sun4 to 68000 */
	temp = *(head+oLONGPOSN);
	*(head+oLONGPOSN) = *(head+oDOUBTWOPOSN);
	*(head+oDOUBTWOPOSN) = *(head+oDOUBONEPOSN);
	*(head+oDOUBONEPOSN) = temp;
}

#ifdef IAG
main()
{
	struct item_header	*item;
	int32			pitem[128];

	printf("sizeof(struct item_header) = %d\n",sizeof(struct item_header));
	pitem[106] = 1;
	pitem[107] = 2;
	pitem[108] = 3;
	printf("106 = %d\n",pitem[106]);
	printf("107 = %d\n",pitem[107]);
	printf("108 = %d\ncalling swap ...\n",pitem[108]);
	sun4swap(pitem);
	printf("106 = %d\n",pitem[106]);
	printf("107 = %d\n",pitem[107]);
	printf("108 = %d\n",pitem[108]);
	item = (struct item_header *)pitem;
	printf("datapresent = %d\n",item->datapresent);


	printf("sizeof(struct item_header) = %d\n",sizeof(struct item_header));
	pitem[106] = 2;
	pitem[107] = 3;
	pitem[108] = 1;
	item = (struct item_header *)pitem;
	printf("datapresent = %d\n",item->datapresent);
	printf("106 = %d\n",pitem[106]);
	printf("107 = %d\n",pitem[107]);
	printf("108 = %d\ncalling unswap ...\n",pitem[108]);
	sun4unswap(pitem);
	printf("106 = %d\n",pitem[106]);
	printf("107 = %d\n",pitem[107]);
	printf("108 = %d\n",pitem[108]);
}
#endif
#endif

