/* sylist -- list SY item in Hertz and dB */

/* m.a.huckvale - december 1985 */

/* version 1.1 - feb 86
	- "-a" switch to include annotations in listing
version 1.2 - may 1986
	- Release 1, new format SY
version 2.0 - March 1989
	- SFS version
*/
/* version 2.1 - September 2000
	- add support for binary format
*/

/*--------------------------------------------------------------------------*/
/**MAN
.TH SYLIST SFS1 UCL 
.SH NAME
sylist - list synthesizer control codes item as text
.SH SYNOPSIS
.B sylist
(-I) (-i item) (-a) (-b binaryfile) file
.SH DESCRIPTION
.I sylist
lists a SY item in Hertz and dB to the standard output or to a binary
file.
An option allows the inclusion of segment boundaries from an annotation item.
.PP
.I Options
and their meanings are:
.TP 11
.B -I
Identify program and exit.
.TP 11
.BI -i item
Select input item type and subtype.
.TP 11
.B -a
Delimit segments in output using annotations.
.TP 11
.BI -b binaryoutfile
Save the formant data to a binary output file suitable for use
with the ActiveX formant synthesizer component SAMPASynth.
.SH INPUT ITEMS
.IP SY 11
Any SY item.
.IP AN 11
Optional annotation item
.SH VERSION/AUTHOR
2.1 - Mark Huckvale
.SH SEE ALSO
syout, syload
*/
/*--------------------------------------------------------------------------*/

/* program name and version */
#define	PROGNAME "sylist"
#define PROGVERS "2.1"
char *progname=PROGNAME;

/* global declarations */
#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "sfs.h"		/* database filing system structures */

/* global data */
struct item_header syitem;	/* filing system item header for sy */
struct item_header anitem;	/* item header for An item */

/* binary file header */
struct formant_binary_file_header {
	char	magic[4];		/* FMNT */
	int32	version;		/* 1 */
	int32	headerlen;		/* 28 */
	int32	layout;			/* 1=standard JSRU */
	int32	numparam;		/* 12 for JSRU */
	int32	framerate;		/* #frames/sec = 100 */
	int32	numframe;		/* # of frames */
} fmhead;
	
/* buffers */
short		*sy;
struct an_rec	*an;

/* main program */
void main(argc,argv)
int	argc;
char	*argv[];
{
	/* option decoding */
	extern int	optind;		/* option index */
	extern char	*optarg;	/* option argument ptr */
	int		errflg = 0;	/* option error flag */
	int		annreq=0;	/* annotation not required */
	char		*antype="0";	/* default annotation item = last */
	char		*sytype ="0";	/* default SY item = last */
	int		c;		/* option switch */
	int32		it;		/* item/sub-type specifiers */
	char		*ty;
	/* file variables */
	char		filename[SFSMAXFILENAME];	/* dbase file name */
	int		fid;
	/* processing variables */
	int		i,j,anidx=0;
	double		sytime;		/* time of current frame */
	double		antime=0;	/* time of annotation */
	/* binary file */
	char		bfilename[SFSMAXFILENAME];
	int		dobinary=0;
	FILE		*op;
	short		buf[32];

	/* decode switches */
	while ( (c = getopt(argc,argv,"Ii:ab:")) != EOF )
		switch (c) {
		case 'I' :	/* Identify */
			fprintf(stderr,"%s: List synthesizer control data V%s\n",PROGNAME,PROGVERS);
			exit(0);
			break;
		case 'a' :	/* annotation required */
			annreq++;
			break;
		case 'i' :	/* specific item */
			if (itspec(optarg,&it,&ty) == 0) {
				if (it == SY_TYPE)
					sytype = ty;
				else if (it == AN_TYPE) {
					antype = ty;
					annreq++;
				}
				else
					error("unsuitable item specifier %s",optarg);
			}
			else
				error("illegal item specifier %s",optarg);
			break;
		case 'b' :	/* binary file output */
			strcpy(bfilename,optarg);
			dobinary=1;
			break;
		case '?' :	/* unknown */
			errflg++;
	}
	/* check for option decoding error */
	if (errflg || (argc<2))
		error("usage: %s (-I) (-a) (-i item) (-b binaryfile) file",PROGNAME);

	/* get filename */
	if (optind < argc)
		strcpy(filename,sfsfile(argv[optind]));
	else
		error("no database file specified",NULL);

	/* load annotation item if required */
	if (annreq)
		getitem(filename,AN_TYPE,antype,&anitem,(void **)&an);

	/* locate SY item */
	if ((fid=sfsopen(filename,"r",NULL)) < 0)
		error("access error on '%s'",filename);
	if (!sfsitem(fid,SY_TYPE,sytype,&syitem))
		error("cannot find input SY item in '%s'",filename);

	/* allocate SY buffer */
	if ((sy=(short *)sfsbuffer(&syitem,1))==NULL)
		error("cannot allocate SY buffer",NULL);

	if (dobinary) {
		if ((op=fopen(bfilename,"wb"))==NULL)
			error("could not open '%s'",bfilename);
		strncpy(fmhead.magic,"FMNT",4);
		fmhead.version=1;
		fmhead.headerlen=sizeof(fmhead);
		fmhead.layout=1;
		fmhead.numparam=12;
		fmhead.framerate=100;
		fmhead.numframe=syitem.numframes;
		if (fwrite((char *)&fmhead,sizeof(fmhead),1,op)!=1)
			error("write error on '%s'",bfilename);
	}
	else {
		/* list data */
		printf("*  fx   f1   a1   f2   a2   f3   a3   f4   a4   fn   an    v\n");
	}
	if (annreq) {
		antime = anitem.offset + an[anidx].posn * anitem.frameduration;
	}
	sytime=syitem.offset;
	for (i=0;sfsread(fid,i,1,sy);i++) {
		if (dobinary) {
			hwsynthcode(sy,buf);
			for (j=0;j<12;j++) putc((char)(buf[j]),op);
		}
		else {
			sytime += syitem.frameduration;
			while ((annreq) && (antime < sytime) && (anidx<anitem.numframes-1)) {
				printf("%s\n",an[anidx].label);
				antime = anitem.offset + an[++anidx].posn * anitem.frameduration;
			}
			printf("%5d",sy[0]);
			printf("%5d%5.1f",sy[3],sy[4]/10.0);
			printf("%5d%5.1f",sy[6],sy[7]/10.0);
			printf("%5d%5.1f",sy[9],sy[10]/10.0);
			printf("%5d%5.1f",sy[12],sy[13]/10.0);
			printf("%5d%5.1f",sy[15],sy[16]/10.0);
			printf("%5d\n",sy[18]);
		}
	}

	/* and exit */
	if (dobinary) fclose(op);
	sfsclose(fid);
	exit(0);
}

