/* arraytest.sml -- test array declarations and access */

/* old style array */
var	varray1[10:20];
string	sarray1[10:20];
stat	tarray1[10:20];

/* new style simple array */
var	varray2[100];
string	sarray2[100];
stat	tarray2[100];

/* new 2D array */
var	varray3[10,20];
string	sarray3[10,20];
stat	tarray3[10,20];

function var atest(a1,a2)
var a1[]
{
	var a2[]
	
	print "atest(a1[2,3])=",a1[2,3],"\n";
	print "atest(a2[2,3])=",a2[2,3],"\n";
}
	
init {
	var	i,j;

	print "varray1: lo=",lobound(varray1):1," hi=",hibound(varray1):1,"\n";
	print "sarray1: lo=",lobound(sarray1):1," hi=",hibound(sarray1):1,"\n";
	print "tarray1: lo=",lobound(tarray1):1," hi=",hibound(tarray1):1,"\n";
	print "varray2: lo=",lobound(varray2):1," hi=",hibound(varray2):1,"\n";
	print "sarray2: lo=",lobound(sarray2):1," hi=",hibound(sarray2):1,"\n";
	print "tarray2: lo=",lobound(tarray2):1," hi=",hibound(tarray2):1,"\n";
	print "varray3: lo=",lobound(varray3):1," hi=",hibound(varray3):1,"\n";
	print "sarray3: lo=",lobound(sarray3):1," hi=",hibound(sarray3):1,"\n";
	print "tarray3: lo=",lobound(tarray3):1," hi=",hibound(tarray3):1,"\n";

	varray1[15]=1;
	varray2[15]=2;
	varray3[15]=3;
	varray3[5,6]=4;

	print "varray1[15]=",varray1[15],"\n";
	print "varray2[15]=",varray2[15],"\n";
	print "varray3[15]=",varray3[15],"\n";
	print "varray3[5,6]=",varray3[5,6],"\n";

	/* these should generate index errors */
	print "varray1[21]=",varray1[21],"\n";
	print "varray2[101]=",varray2[101],"\n";
	print "varray3[201]=",varray3[201],"\n";
	print "varray3[5,25]=",varray3[5,25],"\n";

	/* initialise values */
	for (i=1;i<=5;i=i+1) {
		for (j=1;j<=10;j=j+1) {
			varray3[i,j] = i*j;
		}
	}
	
	/* adjust values */
	for (i=1;i<=5;i=i+1) {
		for (j=1;j<=10;j=j+1) {
			varray3[i,j] = varray3[i,j] + 10;
		}
	}
	
	/* print values */
	for (i=1;i<=5;i=i+1) {
		for (j=1;j<=10;j=j+1) {
			print varray3[i,j]:4," ";
		}
		print "\n";
	}

	tarray3[2,3] += 10;
	print "tarray3[2,3].count=",tarray3[2,3].count,"\n";

	atest(varray3,varray3);
}

