/* convert CO item into DI item */

item co;
item di;

main {
	var	i,j,numf,fsize;
	var e,maxe;

	sfsgetitem(co,$filename,"co");
	numf=sfsgetparam(co,"numframes");
	fsize=sfsgetparam(co,"framesize");
	
	sfsnewitem(di,DI,sfsgetparam(co,"frameduration"),sfsgetparam(co,"offset"),fsize,numf);

	/* find largest value */
	maxe = sfsgetdata(co,0,0);
	for (i=0;i<numf;i=i+1) {
		for (j=0;j<fsize;j=j+1) {
			e = sfsgetdata(co,i,j);
			if (e > maxe) maxe=e;
		}
	}
	print "Maximum energy=",maxe,"dB\n";

	/* do conversion of top 50dB into 16 grey levels */
	maxe = maxe-50;
	for (i=0;i<numf;i=i+1) {
		sfssetfield(di,i,0,sfsgetfield(co,i,0));
		sfssetfield(di,i,1,sfsgetfield(co,i,1));
		for (j=0;j<fsize;j=j+1) {
			e = sfsgetdata(co,i,j);
			if (e > maxe) {
				sfssetdata(di,i,j,16*(e-maxe)/50);
			}
			else {
				sfssetdata(di,i,j,0);
			}
				
		}
	}

	sfsputitem(di,$filename,numf);
}
