/* ffttest.sml - demonstrate use of FFT */

init {
	var sig[0:31];
	var mag[0:15];
	var phs[0:15];
	var twopi;
	var i,siz;
	
	/* get 2*pi */
	twopi = 8*atan(1.0);

	/* build a signal of two sinusoids */
	for (i=0;i<32;i=i+1) sig[i] = 5+10*sin(3*twopi*i/32) + 20*cos(5*twopi*i/32);
	
	/* get amplitudes & phases */
	siz=fft(sig,32,mag,phs);
	
	/* print */
	print "mag=";
	for (i=0;i<siz;i=i+1) print (mag[i]/siz):3," ";
	print "\n";
	print "phs=";
	for (i=0;i<siz;i=i+1) print (360*phs[i]/twopi):3," ";
	print "\n";
}

/* output is:
mag= 10   0   0  10   0  20   0   0   0   0   0   0   0   0   0   0
phs=  0 108 119  90  45   0  -1 115   0  90 -127  35 135 -47  87 -90
*/
