/* fxcomp.sml -- compare two Fx items */

var	voice[0:3]
stat	fxdiff
item	fx1,fx2

main {
	var	i,num,f1,f2,t,idx;

	sfsgetitem(fx1,$filename,"fx.");
	sfsgetitem(fx2,$filename,"fx");
	
	num=sfsgetparam(fx1,"numframes");
	for (i=0;i<num;i=i+1) {
			f1 = sfsgetdata(fx1,i,0);
			t = sfsgetparam(fx1,"offset")+i*sfsgetparam(fx1,"frameduration");
			idx = trunc(0.5+(t-sfsgetparam(fx2,"offset"))/sfsgetparam(fx2,"frameduration"));
			f2 = sfsgetdata(fx2,idx,0);
			if (f1 && f2) {
				if ((f1>0)&&(f2>0)) {
					fxdiff += f1-f2;
					voice[3] = voice[3]+1;
				}
				else if ((f1>0)&&(f2==0)) {
					voice[2] = voice[2]+1;
				}
				else if ((f1==0)&&(f2>0)) {
					voice[1] = voice[1]+1;
				}
				else {
					voice[0] = voice[0]+1;
				}
			}
	}
	
}

summary {
	print "Quantity:\n"
	print "    Files   : ",$filecount:1,"\n"
	print "    Frames  : ",voice[0]+voice[1]+voice[2]+voice[3],"\n"
	print "\nVoicing Analysis:\n"
	print "              Test v-   Test v+\n"
	print "    Ref v-  :",voice[0]:8,"  ",voice[1]:8,"\n"
	print "    Ref v+  :",voice[2]:8,"  ",voice[3]:8,"\n"
	print "    Accuracy:",(100*(voice[0]+voice[3]))/(voice[0]+voice[1]+voice[2]+voice[3]):10:2,"%\n"
	print "\nFx difference:\n"
	print "    Ref-Test: ",fxdiff.mean:1:2," +/- ",fxdiff.stddev:1:3,"Hz\n"
}
