/* spblock - example of block processing of speech */

item sp;				/* input speech item */
item co;				/* output spectral coefficients */
var window[0:10000];	/* input window */
var mag[0:10000];		/* spectral magnitudes */
var phase[0:10000];		/* spectral phases */

main {
	var	numf;
	var	fsize;
	var	fdur;
	var	i,j,f;
	var	xsize,cnt;

	/* load speech item from current file */
	sfsgetitem(sp,$filename,"sp.");

	/* get processing parameters */
	numf = sfsgetparam(sp,"numframes");
	fdur = sfsgetparam(sp,"frameduration");
	fsize = 0.025/fdur;		/* 25ms window */
	xsize = 16;				/* FFT size */			
	while (xsize < fsize) xsize = xsize*2;
	xsize = xsize/2;

	/* make up a coefficients item */
	sfsnewitem(co,CO,fdur,0,xsize,1+2*numf/fsize);

	/* process in blocks */
	f=0;
	for (i=0;(i+fsize)<numf;i=i+fsize/2) {
		sfsgetarray(sp,i,fsize,window);

		cnt=fft(window,fsize,mag,phase);
		if (cnt!=xsize) abort("size error");
		
		sfssetfield(co,f,0,i);
		sfssetfield(co,f,1,fsize);
		sfssetfield(co,f,2,0);
		sfssetfield(co,f,3,0);
		sfssetfield(co,f,4,0);
		for (j=0;j<xsize;j=j+1) {
			sfssetdata(co,f,j,20*log10(mag[j]));
		}
		f=f+1;
	}

	/* save spectral coefficients back to file */	
	sfsputitem(co,$filename,f);
}
