/* lex -- lexical routines for SML */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <string.h>
#include "sml.h"
#ifdef DOS
#include "y_tab.h"
#else
#include "y.tab.h"
#endif

/* global initialisation */
int	begline=1;		/* line start flag */

#ifdef DEBUG
int GETC(ip)
FILE *ip;
{
	int	c;
	c = getc(ip);
	if ((c >= ' ') && (c < 0x7F))
		putchar(c);
	else
		printf("'x%02X'",c);
	if (c=='\n') putchar('\n');
	fflush(stdout);
	return(c);
}
#else
#define GETC getc
#endif

/* yylex definition */
int c;
int yylex()
{
	double	d;
	char	sbuf[100], *p;
	int	s,c2;

	do {
		while ((c=GETC(ip)) == ' ' || c=='\t') /* skip */ ;
		if (c=='\\') {
			if ((c2=GETC(ip)) == '\n') {
				c=GETC(ip);
				if (fstackptr==0) {
					sline[slent].lineno = ++lineno;
					sline[slent].fptr = ftell(ip);
					begline++;
				}
			}
			else
				ungetc(c2,ip);
		}
		else if (c=='/') {		/* possible comment */
			if ((c2=GETC(ip)) != '*')
				ungetc(c2,ip);
			else {
				/* skip comment until */
				c=GETC(ip);
				do {
					c2=c;
					c=GETC(ip);
					if (c=='\n') {
						if (fstackptr==0) {
							sline[slent].lineno = ++lineno;
							sline[slent].fptr = ftell(ip);
							begline++;
						}
					}
				} while (!(c2 == '*' && c == '/') && (c != EOF));
				c=GETC(ip);
			}
		}
		if (c==EOF) {
			if (fstackptr==0)
				return(0);
			else {
				fclose(ip);
				ip = fstack[--fstackptr];
				c = GETC(ip);
			}
		}
	} while ((c == ' ') || (c == '\t'));

	if (isdigit (c)) {	/* number */
		ungetc(c,ip);
		fscanf(ip,"%lf",&d);

		s = install("",NUMBER,d);
		stab[s].vtype = NOTYPE;
		yylval = s;
		if (begline) {
			sline[slent++].pc=pc;
			begline=0;
		}
		return(NUMBER);
	}
	if (isalpha(c) || (c == '$')) {		/* general token */
		p = sbuf;
		do {
			if (p >= (sbuf + sizeof(sbuf) - 1)) {
				*p ='\0';
				warning("name too long",sbuf);
			}
			*p++ = c;
		} while (((c=GETC(ip)) != EOF) && ((c=='_') || (isalnum(c))));
		ungetc(c,ip);
		*p='\0';
		if ((s=lookup(sbuf)) == 0) {
			if (vardecflag == UNDEF) {
				warning("undeclared variable",sbuf);
				s = install(sbuf,VAR,0.0);
				stab[s].stat=LOCAL;
			}
			else {
				/* add new variable */
				s = install(sbuf,UNDEF,0.0);
				stab[s].stat = globalflag;
			}
		}
		else if ((vardecflag != UNDEF) &&
			 (stab[s].stat == BLTIN)) {
			/* add new variable */
			s = install(sbuf,UNDEF,0.0);
			stab[s].stat = globalflag;
		}
		yylval = s;
		if (begline) {
			sline[slent++].pc=pc;
			begline=0;
		}
		return(stab[s].type);
	}
	if (c=='"') {		/* quoted string */
		for (p=sbuf;(c=GETC(ip)) != '"'; p++) {
			if (c=='\n' || c== EOF) {
				warning("missing quote",(char *) 0);
				if (c=='\n') {
					if (fstackptr==0) {
						sline[slent].lineno = ++lineno;
						sline[slent].fptr = ftell(ip);
						begline++;
					}
				}
				break;
			}
			if (p>=sbuf + sizeof(sbuf) -1) {
				*p='\0';
				warning("string too long",sbuf);
				break;
			}
			*p = backslash(c);
		}
		*p = '\0';
		s = install("",STRING,0.0);
		stab[s].stat = GLOBAL;
		stab[s].u.str=(char *) Malloc(strlen(sbuf)+1);
		strcpy(stab[s].u.str,sbuf);
		yylval = s;
		if (begline) {
			sline[slent++].pc=pc;
			begline=0;
		}
		return(STRING);
	}
	if (begline) {
		sline[slent++].pc=pc;
		begline=0;
	}
	switch (c) {
	case '>':	if (follow('=',GE,GT) == GE) return(GE); else return follow('>',SCONCAT,GT);
	case '<':	return follow('=',LE,LT);
	case '=':	return follow('=',EQ,'=');
	case '!':	return follow('=',NE,NOT);
	case '|':	return follow('|',OR,'|');
	case '&':	return follow('&',AND,'&');
	case '+':	if (follow('=',UPDATE,'+') == UPDATE) return(UPDATE); else return follow('+',CONCAT,'+');
	case '\n':	if (fstackptr==0) {
				sline[slent].lineno = ++lineno;
				sline[slent].fptr = ftell(ip);
				begline++;
			}
			return('\n');
	case '\r':	return(' ');
	default:	return(c);
	}
}

/* get char with backslash and ">>" chars interpreted */
int backslash(c)
int	c;
{
	static char transtab[]="b\bf\fn\nr\rt\t>>\"\"\n \\\\";
	if (c == '\\') {
		c = GETC(ip);
		if (strchr(transtab,c))
			return(strchr(transtab,c)[1]);
		ungetc(c,ip);
		return('\\');
	}
	else if (c == '>') {
		c = GETC(ip);
		if (c == '>')
			return(ANNSEP);
		ungetc(c,ip);
		return('>');
	}
	else
		return(c);
}

/* look ahead for digraphs */
int follow(expect,ifyes,ifno)
int	expect,ifyes,ifno;
{
	int	c=GETC(ip);
	if (c==expect)
		return(ifyes);
	ungetc(c,ip);
	return(ifno);
}

/* dump source line table */
void dumpsline()
{
	int	i;
	for (i=0;i<slent;i++)
		printf("line=%2d, fptr=%5d, pc=%3d\n",
			sline[i].lineno,
			sline[i].fptr,
			sline[i].pc);
}

#ifndef _MSC_VER
/* return user's home directory */
#include <pwd.h>
char	*homedir()
{
	struct passwd	*pwd;
	int		uid;

	uid=getuid();
	while ((pwd=getpwent()) != NULL) {
		if (pwd->pw_uid == uid) {
			endpwent();
			return(pwd->pw_dir);
		}
	}
	endpwent();
	return(NULL);
}
#endif

/* switch input to library routine */
void looklib(entry)
int	entry;
{
	char	libname[256];
	FILE	*newip;

	/* check local directory */
	strcpy(libname,"./");
	strcat(libname,stab[entry].name);
	strcat(libname,".s");
	newip=fopen(libname,"r");
#ifndef _MSC_VER
	if (newip == NULL) {
		/* try home directory */
		strcpy(libname,homedir());
		strcat(libname,"/sml/");
		strcat(libname,stab[entry].name);
		strcat(libname,".s");
		newip = fopen(libname,"r");
	}
#endif
	if (newip == NULL) {
		/* try user library directory */
		strcpy(libname,"/usr/lib/sml/");
		strcat(libname,stab[entry].name);
		strcat(libname,".s");
		newip = fopen(libname,"r");
	}
	if (newip == NULL)
		warning("no access to library routine",stab[entry].name);
	else if (fstackptr==(MAXFSTACK-1))
		yyerror("too many nested library calls");
	else {
		Free(stab[entry].name);
		stab[entry].name = (char *) Malloc(strlen(libname)+1);
		strcpy(stab[entry].name,libname);
		fstack[fstackptr++] = ip;
		ip = newip;
	}
}
