/* pgraph -- X-Y graphs for Speech Pascal */

/* M.A.Huckvale - University College London */

/* version 1.1 - December 1993
	- add xinc
	- change names
*/
/* version 1.2 - December 1994
	- free strings after use
	- add graphplotxy
	- add graphplotlogxy
*/

#include "SFSCONFG.h"
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include <ctype.h>

#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#include "spc.h"
#include "spcc.h"
#include "sfs.h"
#include "dig.h"
#include "digdata.h"
#include "dgraph.h"

/* complex type */
typedef struct { double re,im; } COMPLEX;

/* Global Variables */
static int	ghoriz;		/* # graphs across X */
static int	gvert;		/* # graphs across Y */

/* Initialise Graphics */
void	graphinit_(op,nhoriz,nvert,title)
filedesc	op;
int32		nhoriz;
int32		nvert;
string		title;
{
	ghoriz = (nhoriz < 1) ? 1 : ((nhoriz > 8) ? 8 : nhoriz);
	gvert = (nvert < 1) ? 1 : ((nvert > 8) ? 8 : nvert);

	digstart('\0',(op==stdout)?NULL:op,1);

	digclearscreen();
	digscale((double)ghoriz,(double)(gvert)*1.1,0);

	digboxtext(24,(double)ghoriz/2.0,(double)gvert*1.065,(double)ghoriz,(double)gvert/30.0,0.0,title.buf.ar,1);
	digline(24,0.0,(double)gvert*1.05,(double)ghoriz,(double)gvert*1.05);
	_sfree(title);
}

/* plot a basic X-Y graph */
void	graphploty_(gno,xinc,ydata,ycnt,xtitle,ytitle,ptitle)
int32	gno;
double	xinc;
double	ydata[];
int32	ycnt;
string	xtitle,ytitle,ptitle;
{
	int	gx,gy;
	double	xdata[2];

	gx = (gno-1) % ghoriz;
	gy = (gno-1) / ghoriz;

	digscale((double)ghoriz,(double)(gvert)*1.15,0);
	digorigin((double)gx,(double)(gvert-gy-1)*1.05);

	xdata[0] = xinc;
	xdata[1] = xinc;

	dgraph((short *)xdata,(short *)ydata,ycnt,DGdouble|DGinc,DGdouble,DGline,20,NULL,xtitle.buf.ar,ytitle.buf.ar);

	digboxtext(20,0.5,1.0,1.0,0.07,0.0,ptitle.buf.ar,1);
	_sfree(xtitle);
	_sfree(ytitle);
	_sfree(ptitle);

}

/* plot a standard X-Y graph */
void	graphplotxy_(gno,xdata,ydata,ycnt,xtitle,ytitle,ptitle)
int32	gno;
double	xdata[];
double	ydata[];
int32	ycnt;
string	xtitle,ytitle,ptitle;
{
	int	gx,gy;

	gx = (gno-1) % ghoriz;
	gy = (gno-1) / ghoriz;

	digscale((double)ghoriz,(double)(gvert)*1.15,0);
	digorigin((double)gx,(double)(gvert-gy-1)*1.05);

	dgraph((short *)xdata,(short *)ydata,ycnt,DGdouble,DGdouble,DGline,20,NULL,xtitle.buf.ar,ytitle.buf.ar);

	digboxtext(20,0.5,1.0,1.0,0.07,0.0,ptitle.buf.ar,1);
	_sfree(xtitle);
	_sfree(ytitle);
	_sfree(ptitle);

}

/* plot a log X-Y graph */
void	graphplotlogxy_(gno,xdata,ydata,ycnt,xtitle,ytitle,ptitle)
int32	gno;
double	xdata[];
double	ydata[];
int32	ycnt;
string	xtitle,ytitle,ptitle;
{
	int	gx,gy;

	gx = (gno-1) % ghoriz;
	gy = (gno-1) / ghoriz;

	digscale((double)ghoriz,(double)(gvert)*1.15,0);
	digorigin((double)gx,(double)(gvert-gy-1)*1.05);

	dgraph((short *)xdata,(short *)ydata,ycnt,DGdouble|DGlogax,DGdouble,DGline,20,NULL,xtitle.buf.ar,ytitle.buf.ar);

	digboxtext(20,0.5,1.0,1.0,0.07,0.0,ptitle.buf.ar,1);
	_sfree(xtitle);
	_sfree(ytitle);
	_sfree(ptitle);

}

/* plot a pole/zero graph */
void	graphplotz_(gno,pdata,pcnt,zdata,zcnt,ptitle)
int32	gno;
COMPLEX	pdata[];
int32	pcnt;
COMPLEX	zdata[];
int32	zcnt;
string	ptitle;
{
	int	gx,gy;
	double	xcircle[201],ycircle[201];
	double	xdata[50],ydata[50];
	int	i;

	gx = (gno-1) % ghoriz;
	gy = (gno-1) / ghoriz;

	digscale((double)ghoriz,(double)(gvert)*1.15,0);
	digorigin((double)gx,(double)(gvert-gy-1)*1.05);

	/* plot axes and unit circle */
	for (i=0;i<200;i++) {
		xcircle[i] = cos(2*3.14159*i/200.0);
		ycircle[i] = sin(2*3.14159*i/200.0);
	}
	xcircle[200] = xcircle[0];
	ycircle[200] = ycircle[0];
	
	dgraph((short *)xcircle,(short *)ycircle,201,DGdouble,DGdouble,DGline|DGequal,20,NULL,"Real","Imaginary");

	for (i=0;(i<zcnt)&&(i<50);i++) {
		xdata[i] = zdata[i].re;
		ydata[i] = zdata[i].im;
	}
	
	dgraph((short *)xdata,(short *)ydata,zcnt,DGdouble|DGsame,DGdouble|DGsame,DGpoints|DGequal,20,"O","","");

	for (i=0;(i<pcnt)&&(i<50);i++) {
		xdata[i] = pdata[i].re;
		ydata[i] = pdata[i].im;
	}
	
	dgraph((short *)xdata,(short *)ydata,pcnt,DGdouble|DGsame,DGdouble|DGsame,DGpoints|DGequal,20,"X","","");

	digboxtext(20,0.5,1.0,1.0,0.07,0.0,ptitle.buf.ar,1);

	_sfree(ptitle);

}

void graphend_()
{
	while (digwait()==DIG_REDRAW) /* loop */;
	digquit(0);
}

#ifdef EMO

double	ydata[10]={0.11,0.13,0.20,0.29,0.35,0.44,0.57,0.66,0.89,1.2};
double	waveform[256];

main()
{
	int	i;
#if 0	
	graphinit_(stdout,1,1,"Single Graph");

	PlotY(1,ydata,10,"Index","Value","Plot Title");

	GraphEnd();

	GraphInit(stdout,2,2,"Quad Graph");

	for (i=1;i<=4;i++)
		PlotY(i,ydata,10,"Index","Value","Plot Title");

	GraphEnd();

	GraphInit(stdout,1,2,"Double Graph");

	for (i=0;i<10;i++) ydata[i] -= 0.5;

	for (i=1;i<=2;i++)
		PlotY(i,ydata,10,"Index","Value","Plot Title");

	GraphEnd();
#endif
	GraphInit(stdout,1,2,"Waveform Generation");

	for (i=0;i<256;i++) waveform[i] = sin(i*2.0*3.141593/16);

	PlotY(1,waveform,256,"Time","Amplitude","Sine Wave");

	for (i=0;i<256;i++) waveform[i] = (double)(rand()%0x7FFF)/(double)0x4000 - 1.0;

	PlotY(2,waveform,256,"Time","Amplitude","Noise");

	GraphEnd();

}
#endif
