/* dig.h -- include file for device independent graphics */

#ifndef _DIG_H
#define _DIG_H

#include "sfs.h"

/* character constants */
#define	BELL		7
#define BACKSP		8
#define NEWLINE		'\n'
#define	ESC		27

/* dig manifest constants */
#define DEG_TO_RADS 0.017453292

/* scaling equations	*/
#define xpix(x) ((int) ((x)*digdata.xscale + digdata.xorig))
#define ypix(y) ((int) ((y)*digdata.yscale + digdata.yorig))

/* dig device selection meta-codes */
#define DIG_DEFAULT_TERM	'\0'
#define DIG_DEFAULT_PRINTER	'\001'

/* return codes from mouse and pause routines */
#define DIG_QUIT	-1
#define DIG_KEY		-2
#define DIG_MOUSE	-3
#define DIG_REDRAW	-4

#ifdef __cplusplus
extern "C" {
#endif
#ifdef __STDC__
void   digstart(char  dev,FILE *fileptr,int  trapints);
void   digint(int dummy);
void   digend(void);
void   digquit(int  action);
void   digscale(float  x,float  y,int  equal);
void   digclearscreen(void);
int    digwait(void);
void   digline(int  bundle,float xstart,float ystart,float xend,float yend);
void   diglinep(int  bundle,int  x1,int  y1,int  x2,int  y2);
void   digiplot(int  x,int  y);
void   digflush(void);
void   digorigin(float x,float y);
void   digclip(float  xmin,float  ymin,float  xmax,float  ymax);
int    digclippush(void);
int    digclippop(void);
void   digtext(int bundle,float xstr,float ystr,char    *word);
void   digtextp(int  bundle,int  x,int  y,char  *word);
void   digboxp(int  bundle,int  trx,int  tpy,int  blx,int  bly);
void   digbox(int  bundle,float     trx,float  tpy,float  blx,float  bly);
void   digfont(char  *name);
void   digfillbox(int  bundle,float  trx,float  tpy,float  blx,float  bly);
void   digfillboxp(int  bundle,int  trx,int  tpy,int  blx,int  bly);
int    diglinemode(int  mode);
void   digvtext(int  bundle,float  xstr,float  ystr,char  *word,float  height,float  angle,int  prop);
void   digboxtext(int  bun,float  x,float  y,float  len,float  height,float  ang,char  *txt,int prop);
float  digvtextlen(char  *word,float  height,float  angle,int  prop);
void   digwave(int  bundle,float  xl,float  yb,float  xr,float  yt,short  *buff,int32  count,int  maxval,int  minval);
float  digtextlen(char  *word);
void   digsetup(float  width,float  height,char    dev,FILE *fileptr);
void   digcircle(int  bundle,float  xc,float  yc,float  radius);
void   digcirclep(int  bundle,int  xc,int  yc,int  radius);
void   digarc(int  bundle,float     x1,float  y1,float  x2,float  y2,float  x3,float  y3);
void   digarcp(int  bundle,int  px1,int  py1,int  px2,int  py2,int  px3,int  py3);
void   digarcent(int  bundle,float  x1,float  y1,float  x2,float  y2,float  xc,float  yc);
void   digfillcircle(int  bundle,float  xc,float  yc,float  radius);
void   digfillcirclep(int  bundle,int  xc,int  yc,int  r);
int    diginitmouse(float  xm,float  ym);
int    diginitmousep(int  xm,int  ym);
void   digkillmouse(void);
int    diggetmousech(int  *button,float  *xm,float  *ym);
int    diggetmousechp(int  *button,int  *xm,int  *ym);
int    diggetmouse(char *,char *,float  *,float  *);
int    diggetmousep(char *,char *,int  *,int  *);
void   digprompt(char  *str);
void   diggreyscale(int   bundle,float  xl,float   yb,float  xr,float  yt,char  *buff,int  length,int  height,int  depth);
void   diggreyscalep(int  bundle,int  xl,int  yb,int  xr,int  yt,char  *buff,int  length,int  height,int  depth);
int    digitemtime(int32  bundles,float  xl,float    yb,float  xr,float  yt,double  start,double  stop,int  flags);
int    digitemfreq(int32  bundles,int  iyb,int  iyt,double  start,double  stop,int  flags);
int    digitemlabel(int32  bundles,int  iyb,int  iyt,char  *labels,int  labfirst,int  labnum);
void   digitbundle(int32  bundles);
void   digitbox(float  xl,float  yb,float  xr,float  yt,double start,double stop,int   flags);
void   digititle(struct  item_header *item,int  flags);
int    digitemSP(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,short  *buff,double  start,double  stop,int  flags);
int    digitemFFT(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,short  *buff,double  start,double  stop,int  flags);
int    digitemLX(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,short  *buff,double  start,double  stop,int  flags);
int    digitemTX(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,int32  *buff,double  start,double  stop,int  flags);
int    digitemFX(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,short  *buff,double  start,double  stop,int  flags);
int    digitemAN(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,struct an_rec *buff,double    start,double   stop,int  flags);
int    digitemSY(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,short  *buff,double  start,double  stop,int  flags);
int    digitemDI(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,struct di_rec *buff,double    start,double   stop,int  flags);
int    digitemCO(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,struct co_rec *buff,double    start,double   stop,int  flags);
int    digitemFM(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,struct fm_rec *buff,double    start,double   stop,int  flags);
int    digitemTR(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,float *buff,double  start,double   stop,int  flags);
int    digitemVU(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,struct vu_rec *buff,double  start,double   stop,int  flags);
int    digitemUG(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,short *buff,double  start,double   stop,int  flags);
int    digitemNULL(int32  bundles,float  xl,float    yb,float  xr,float  yt,struct  item_header *item,char *buff,double   start,double   stop,int  flags);
int    digitemNUM(int32  bundles,float  xl,float    yb,float  xr,float  yt,struct  item_header *item,char *buff,double   start,double   stop,int  flags);
#else
/* dig routines */
float	digtextlen();
float	digvtextlen();
#endif

#ifdef __cplusplus
}
#endif

#endif
