/* digitem.h -- header file for digitem routines */

#include "SFSCONFG.h"

/* display control structure */
struct {
	int	ixl,ixr,iyb,iyt;	/* pixel co-ord of box */
	int	gbun,abun,lbun,dbun;	/* graph bundles */
	int	ixoff;			/* y-axis offset */
	int	iytitle;		/* title position */
	double	scalex;			/* x-axis scaling */
	double	scaley;			/* y-axis scaling */
	double	hi,lo;			/* max, min data values */
	char	*title;			/* text title */
	char	*label;			/* text label */
} digitab;

/* default definitions */
#define AXCHAR	9	/* # chars width of y-axis portion of each graph */
#define DEFBUN	24	/* default bundle when colour unspecified */

/* scaling equations	*/
#define xpix(x) ((int) ((x)*digdata.xscale + digdata.xorig))
#define ypix(y) ((int) ((y)*digdata.yscale + digdata.yorig))
#define xval(x) (((float)(x) - digdata.xorig)/digdata.xscale)
#define yval(y) (((float)(y) - digdata.yorig)/digdata.yscale)

/* format defines */
#define DIGITEMBOX 	1	/* draw outline box */
#define DIGITEMTITLE	2	/* print item title */
#define DIGITEMLABEL	4	/* print item label */
#define DIGITEMFIX	8	/* do not auto-scale */
#define DIGITEMOVERLAY	16	/* overlay on existing graph */
#define DIGITEMGAP	32	/* gap between item and top of box */
#define DIGITEMTOPHAT	64	/* waveforms with top hats */
#define DIGITEMFFTNARROW 128	/* digitemFFT does narrow band */
#define DIGITEMGRID	256	/* display frequency/time grid */
