/* sfs.h -- speech database header structures */

/* m.a. huckvale - november 1985 */

/* this version dated September 1994 */

#ifndef SFS_H
#define SFS_H

#include "SFSCONFG.h"
#include <stdlib.h>
#include <string.h>

/* SPAR DATABASE SYSTEM: */
/* version 2.1 - System Release 1 - June 1986 */
/*             - new "offset" field in item header */
/*	       - new "comment" field in item header */
/* version 2.2 - new WD item and associated data */
/* version 2.3 - new fields in item header
		 modification to formant structure */
/* version 2.4 - added VU(10), EN(13), MM(15) and TR(16) items 
	 	 also MAXDATATYPE constant */
/* version 2.5 - added RP(23) and RR(24) items */
/* version 2.6 - modified link item header */

/* SPEECH FILING SYSTEM:
   version 1.0 - June 1987
   version 1.1 - February 1988
		 added LEEDS articulatory items
   version 1.2 - June 1988 - added UG(25) and XM(26) items
   version 1.3 - August 1989 - sun4 mods
   version 1.4 - March 1993 - added DC(30) item
   version 1.5 - May 1993 -> add ANSI prototypes
   version 1.6 - September 1994 -> add dummy flags field to xm_rec to cope with alignment problems
*/

/* definition of file identifier */
struct file_id {
	char	site[4];	/* site name - e.g. "ucl" */
	int32	num;		/* file number */
};

/* definition of speech database main header */
struct main_header {
	/* file creation information */
	char	hname[4];	/* header name & version */
	int32	creatdate;	/* file creation date */
	char	username[20];	/* username of creator */
	struct file_id fid;	/* unique file identifier */
	/* database information */
	char	source[20];	/* source of recording */
	char	dbase[20];	/* name of database */
	char	speaker[20];	/* speaker name */
	char	session[20];	/* session code */
	char	sessdate[20];	/* session date */
	char	token[160];	/* name of spoken token */
	char	rep[8];		/* token repetition code */
	/* recording information, etc */
	char	environ[8];	/* recording conditions */
	char	archive[20];	/* archiving details */
	char	comment[80];	/* general comments */
	char	spare[96];	/* space for later exapansion */
	int32	machine;	/* machine type */
};

#if defined(SUN4) || defined(HP) || defined(ALPHA)
/* defn of speech database item header with offset & datapresent swapped */
struct item_header {
	char	history[256];	/* processing history */
	char	params[128];	/* special processing parameters */
	int32	processdate;	/* processing date */
	int32	datatype;	/* data type: speech, lx, etc */
	int32	subtype;	/* data sub-type: natural, synthetic, etc */
	int32	floating;	/* fixed or floating data */
	int32	datasize;	/* data item size (bytes) */
	int32	framesize;	/* no. items in time frame */
	int32	numframes;	/* no. frames in data */
	int32	length;		/* overall length (bytes) */
	double	frameduration;	/* time interval duration (s) */
	double	offset;		/* cumulative time offset */
	int32	datapresent;	/* data present 1=yes,0=no */
	char	comment[20];	/* data set comment */
	int32	windowsize;	/* size of analysis window in samples */
	int32	overlap;	/* size of analysis overlap in samples */
	int32	lxsync;		/* flag :larynx syncronous=1,fixed frame=0 */
	char	spare[40];	/* space for expansion */
	int32	machine;	/* machine code: 0=68000, 1=8086 */
};
#else
/* definition of speech database item header - NOT SUN4 */
struct item_header {
	char	history[256];	/* processing history */
	char	params[128];	/* special processing parameters */
	int32	processdate;	/* processing date */
	int32	datatype;	/* data type: speech, lx, etc */
	int32	subtype;	/* data sub-type: natural, synthetic, etc */
	int32	floating;	/* fixed or floating data */
	int32	datasize;	/* data item size (bytes) */
	int32	framesize;	/* no. items in time frame */
	int32	numframes;	/* no. frames in data */
	int32	length;		/* overall length (bytes) */
	double	frameduration;	/* time interval duration (s) */
	int32	datapresent;	/* data present 1=yes,0=no */
	double	offset;		/* cumulative time offset */
	char	comment[20];	/* data set comment */
	int32	windowsize;	/* size of analysis window in samples */
	int32	overlap;	/* size of analysis overlap in samples */
	int32	lxsync;		/* flag :larynx syncronous=1,fixed frame=0 */
	char	spare[40];	/* space for expansion */
	int32	machine;	/* machine code: 0=68000, 1=8086 */
};
#endif

/* structure of link item header */
struct link_header {
	char	filename[128];	/* linked file name */
	char	filepath[128];	/* file access path */
	int32	filetype;	/* file type, 0=binary, 1=SFS, etc */
	int32	datatype;	/* SFS file datatype */
	int32	subtype;	/* SFS file subtype */
	int32	offset;		/* byte offset into data */
	int32	multiplex;	/* data multiplexing size */
	int32	linkdate;	/* date/time of link */
	int32	swab;		/* swap byte flag */
	int32	dcoffset;	/* DC offset (subtracted) */
	int32	shift;		/* sample bit shift */
	char	spare[216];	/* space for expansion */
	int32	machine;	/* SFSMACHINE for file */
};

/* values of item_header.datatype */
#define SP_TYPE 1		/* Speech Pressure Waveform */
#define LX_TYPE	2		/* Larnygograph Signal, etc */
#define TX_TYPE	3		/* Excitation Period Data */
#define FX_TYPE	4		/* Fundamental Frequency Trace */
#define AN_TYPE	5		/* Annotations */
#define LP_TYPE 6		/* Lower Phonetic Item */
#define SY_TYPE 7		/* Synthesizer Control Parameters */
#define WD_TYPE 8		/* Words */
#define DI_TYPE 9		/* Displayable data */
#define VU_TYPE 10		/* Voicing */
#define CO_TYPE 11		/* Coefficient data */
#define FM_TYPE 12		/* Raw formant estimates */
#define EN_TYPE 13		/* Energy */
#define PC_TYPE 14		/* LPC coefficients item */
#define MM_TYPE 15		/* Markov Model */
#define TR_TYPE 16		/* Parameter Track */
				/* 17 spare for GEC recognition item */
#define GE_TYPE 18		/* Geometry item for articulatory model */
#define AE_TYPE 19		/* Aerodynamic data for articulatory model */
#define IP_TYPE 20		/* Source description parameters */
#define SC_TYPE 21		/* Sources for srticulatory model */
#define PH_TYPE 22		/* Physiological data */
#define RP_TYPE 23		/* Rational polynomial filter */
#define RR_TYPE 24		/* Rational rootlist filter */
#define UG_TYPE 25		/* Glottal flow or derivative (item.params contains "derivative=xxxx" */
#define XM_TYPE 26		/* Excitation model (item.params contains "model=xxxx" */
#define NA_TYPE 27		/* Nose in the articulatory model */
#define CA_TYPE 28		/* Calibration type */
#define AR_TYPE 29		/* Area type (e.g. glottal area) */
#define DC_TYPE 30		/* Coefficient dictionary */
#define MAXDATATYPE 30		/* Largest allowed value for datatype */

/* values of link_header.filetype */
#define BINARY_TYPE 0
#define SFS_TYPE 1
#define ILS_TYPE 2
#define NETWORK_TYPE 128

/* maximum # items in sfs file */
#define MAXITEM	200

/* structure of an annotation record */
#define MAXANLABEL 247		/* including final '\0' */
struct	an_rec {
	int32	posn;	/* frame number */
	int32	size;	/* width in frames */
	char	*label; /* annotation label */
};

/* structure of a lower phonetic record */
struct	lp_rec {
	char		sname[8]; 	/* symbol name */
	int32		length1;  	/* duration (ms) 1 */
	int32		pitch1;   	/* pitch (Hz) 1 */
	int32		length2;  	/* duration (ms) 1 */
	int32		pitch2;   	/* pitch (Hz) 2 */
	unsigned char	*alist;		/* attribute list */
};

/* structure of a word record */
#define MAXWDLEN 20
struct	wd_rec {
	int32		start;		  /* start node */
	int32		end;		  /* end node */
	char		symbol[MAXWDLEN]; /* word symbol */
	char		*attr;		  /* word attribute list */
};

/* structure of a display item */
struct di_rec {
	int32	posn;		/* start sample */
	int32	size;		/* window size */
	char	*pixel;		/* pixel list */
};

/* structure of a voicing item */
struct	vu_rec {
	int32	posn;		/* sample number of window start */
	int32	size;		/* size of analysis window */
	int32	flag;		/* 0=unvoiced, 1=voiced */
	float	mix;		/* excitation mix, 0=unvoiced, 1=voiced */
	float	gain;		/* overall gain on frame */
	float	*data;		/* data */
};

/* structure of a coefficients item */
struct	co_rec {
	int32	posn;		/* sample number of window start */
	int32	size;		/* size of analysis window */
	int32	flag;		/* 0=unvoiced, 1=voiced */
	float	mix;		/* excitation mix, 0=unvoiced, 1=voiced */
	float	gain;		/* overall gain on frame */
	float	*data;		/* data */
};

/* structure of an energy item */
struct	en_rec {
	int32	posn;		/* sample number of window start */
	int32	size;		/* size of analysis window */
	int32	flag;		/* 0=unvoiced, 1=voiced */
	float	mix;		/* excitation mix, 0=unvoiced, 1=voiced */
	float	gain;		/* overall gain on frame */
	float	*data;		/* data */
};

/* structure of an lpc item */
struct	pc_rec {
	int32	posn;		/* sample number of window start */
	int32	size;		/* size of analysis window */
	int32	flag;		/* 0=unvoiced, 1=voiced */
	float	mix;		/* excitation mix, 0=unvoiced, 1=voiced */
	float	gain;		/* overall gain on frame */
	float	*data;		/* data */
};

/* structure of a raw formant estimates item */
struct	fm_rec_array {
	float	freq;	/* formant frequency */
	float	amp;	/* formant amplitude */
	float	band;	/* formant bandwidth */
};
struct	fm_rec {
	int32	posn;		/* sample number of window start */
	int32	size;		/* size of analysis window */
	int32	flag;		/* 0=unvoiced, 1=voiced */
	float	gain;		/* overall gain for frame */
	int32	npeaks;		/* number of formant estimates following */
	struct fm_rec_array *formant; /* formant structure */
};
#define ALT_RECL 51			/* number of sections in the vocal tract */
struct ge_rec {
	short areas[ALT_RECL];		/* vocal tract areas in 0.01 mm2 */
	short ag;			/* avarerage glottal area in 0.01 mm2 */
	short av;			/* velo-pharyngeal port are in 0.01 mm2 */
	float q;			/* glottal fold tension */
	float plu;			/* lung air pressure */
	float vc;			/* volume of the main cavity */
	float ac;			/* area of the main constriction */
};
struct ae_rec {
	float psg;			/* subglottal pressure */
	float pc;			/* pressure in the cavity above the glottis */
	float pdiff;			/* pressure drop across the glottis */
	float ug;			/* glottal air flow */
	float uv;			/* nasal air flow */
	float uc;			/* oral air flow */
	float vlu;			/* lung volume */
};
struct ip_rec {
	float voia;			/* voice amplitude envelope */
	float voif;			/* Fx */
	float frica;			/* frication amplitude */
	float frcvpa;			/* frication amplitude at the veulm */
	float aspa;			/* aspiration amplitude */
	float tcr;			/* closed ratio of glottis */
	float td;			/* closing time for glottis */
	float k;			/* assymetry factor for the Fant wave */
};
struct sc_rec {
	float	voice;			/* glottal airflow */
	float	frication;		/* main turbulence source */
	float	fricvp;			/* turbulence source at the velum */
	float 	aspiration;		/* turbulence at the glottis */
	float	dpc;			/* differential pressure for plosives */
	short	agc;			/* larynx synchronous glottal area */
};
struct rp_rec {			/* rational polynomial */
	int32	posn;		/* sample number of window start */
	int32	size;		/* size of analysis window */
	float	gain;		/* gain of filter */
	int32	delay;		/* delay in samples */
	int32	nzero;		/* number of zeros */
	float	*data;		/* coeffs beginning with z**-1 term of top */
};
struct rr_rec {			/* rational rootlist */
	int32	posn;		/* sample number of window start */
	int32	size;		/* size of analysis window */
	float	gain;		/* gain of filter */
	int32 	delay;		/* delay in samples */
	int32	nzero;		/* number of zeros */
	int32	nzpair;		/* number of zero complex pairs */
	int32	nppair;		/* number of pole complex pairs */
	float	*data;		/* complex zeros, real zeros, cmplx poles, real poles */
};
struct xm_rec {			/* excitation model */

/* params field contains "model=xxxxx" to identify model */

	double	start;		/* start (opening) time in sec for this cycle */
	double	length;		/* length in seconds */
	float	amp;		/* amplitude of excitation */
	float	mix;		/* fraction of total power in voiced part */
	int32	flag;		/* DUMMY FLAGS to help alignment */
	float	*data;		/* additional model-dependent parameters */
};


struct na_rec {
	char id[ 80 ];		/* name of this nose */
	short areas[ ALT_RECL ];	/* nasal cross-sections in 0.01mm2 */
	int len;			/* length of the nose in 0.5cm units */
};

struct ca_rec {
	char units[ 80 ];						/* physical units */
	float slope1, resid1;					/* slope through zero and C of G of data */
	float const2, slope2, resid2;			/* Straight line fit */
	float coeff3[ 3 ], resid3;				/* Second order coefficients */
	float min, max;							/* wanted for polynomial evaluation */
};

/* Dictionary record */
struct dc_rec {
	char	label[20];		/* dictionary token name */
	int32	numlabels;		/* number of entries processed */
	int32	numframes;		/* number of frames processed */
	float	dursum;			/* sum of durations */
	float	dursumsq;		/* sum of squared durations */
	float	*data;			/* sum & sumsq of data values in pairs */
};

/* miscellaneous constants */
#define SFSMAXFILENAME 160

/* typedefs */
typedef struct ge_rec GEO_ITEM;
typedef struct ae_rec AERO_ITEM;
typedef struct ip_rec INTER_ITEM;
typedef struct na_rec NOSE_ITEM;
typedef struct ca_rec CAL_ITEM;
typedef struct sc_rec SOURCE_ITEM;

/* sfs routine definitions */
#ifdef __cplusplus
extern "C" {
#endif
#ifdef __STDC__
int	dac_open(char *);
void	dac_close(int);
int32	dac_playback(short *,int32,double,int,int,int);
int32	dos_dac_playback(int,short *,int32,double,int,int,int);
int32	dac_repeat(int32,int32,int);
int	adc_open(char *);
void 	adc_close();
int32	adc_record(short *,int32,double,int,int);

void    error(char *, ...);
void    getitem(char *, int32, char *, struct item_header *, void **);
char   *getline(char *, int);
int     histmatch( /* variable # arguments, all 'char *' */);
void    hwsynthcode(short *, unsigned short *);
int	hwsynth(short *buff,int32 numf);
int     itspec(char *, int32 *, char **);
char   *lab_store(struct item_header *);
void    lab_reset(void);
int     lab_initfile(char *);
char   *lab_getmatch(char *);
char   *lab_gettext(char *);
char   *lab_match(char *, char *);
char   *lab_text(char *, char *, char *, char *);
void    netaccess(char *, char *, int32 *, int32 *);
int32    netread(char *, char *, int32, char *, int32);
double  param(char *, char *, double);
char   *params(char*, char *, char *);
char   *pathname(char *);
void    playback(short *, int32, double);
void    putitem(char *, struct item_header *, int32, void *);
void    putNitems(char *, struct item_header *, int32, void *, int);
int     sfsaddlink(struct item_header *, int32, struct link_header *, char *);
char   *sfsbase(void);
void   *sfsbuffer(struct item_header *, int32);
int     sfschannel(char *, struct item_header *);
int     sfsclose(int);
void    sfsconvd(int32, char *, int32, int);
void    sfsconvi(struct item_header *);
void    sfsconvm(struct main_header *);
int     sfsdup(int);
char   *sfsfile(char *);
int     sfsitem(int, int32, char *, struct item_header *);
void    sfsheader(struct item_header *, int32, int32, int32, int32,
			   double, double, int32, int32, int32);
int     sfsnextitem(int, struct item_header *);
int     sfsopen(char *, char *, struct main_header *);
int     sfsopenlink(int);
int32    sfsread(int, int32, int32, void *);
int     sfstree(char *);
int     sfsupdate(char *);
int32    sfswrite(int, int32, void *);
int     sfswritelink(struct item_header *, int32, struct link_header *,
				 char *);

void	sun4swap(int32 *);
void	sun4unswap(int32 *);
int     ttytest(void);
int     upd_backup(char *, char *);
int     upd_cpfiles(char *, char *);
void    initvideo(int);
void    italicon(void);
void    italicoff(void);
void    boldon(void);
void    boldoff(void);
void    uparrow(void);
#else
char	*sfsbase();
char	*sfsfile();
void	*sfsbuffer();
char	*getline();
double	param();
char	*params();
char	*pathname();
char	*lab_store();
char	*lab_getmatch();
char	*lab_gettext();
#endif
#ifdef __cplusplus
}
#endif

/* global data */
extern int sfsstruct[];
#define SFSRECSIZE(i)	(((i)->datasize*(i)->framesize-sfsstruct[(i)->datatype])/(i)->datasize)

#endif
