/* spcomp - speech compression tables */

/* M.A.Huckvale - University College London */

/* version 1.0 - February 1993 */

static char spcomptab1[32]={
0,96,96,97,97,98,98,99,99,100,100,101,101,102,102,103,104,105,105,106,106,107,107,108,108,109,109,110,110,111,111,0,
};

static char spcomptab2[64]={
32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
};

static int spdecomptab[128]={
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
-32,-31,-30,-29,-28,-27,-26,-25,-24,-23,-22,-21,-20,-19,-18,-17,-16,-15,-14,-13,-12,-11,-10,-9,-8,-7,-6,-5,-4,-3,-2,-1,
64,128,192,256,320,384,448,512,-512,-448,-384,-320,-256,-192,-128,-64,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
};

/* encoding operations */
#define CODE1(diff) (spcomptab1[(((diff) & 0x3E0)>>5)])
#define CODE2(diff) (spcomptab2[(diff) & 0x3F])
#define SAMP_DIFF_MIN	-512
#define SAMP_DIFF_MAX	511
#define SAMP_EOT	0x1A

/* decoding operations */
#define ISVALUE(c)	(((c) & 0x70)==0x70)
#define ISNONTERM(c)	(((c) & 0x70)==0x60)
#define ISTERM(c)	((((c) & 0x70) >= 0x20) && (((c) & 0x70) < 0x60))
#define ISEOT(c)	((c)==SAMP_EOT)
