/* digboxtext -- draw proportionally spaced text within region */

#include <stdio.h>
#include <math.h>
#include "SFSCONFG.h"
#include "dig.h"

/* draw vector text in a fixed size box */
#ifdef __STDC__
void   digboxtext(int  bun,float  x,float  y,float  len,float  height,float  ang,char  *txt,int prop)
#else
void	digboxtext(bun,x,y,len,height,ang,txt,prop)
int 	bun;			/* bundle number */
float 	x,y;			/* coordinates of bottom middle of box */
float	len,height;		/* length and height of box */
float	ang;			/* angle of box */
char 	*txt;			/* text */
int 	prop;			/* proportional flag */
#endif
{
	float lenstr;
	float phi,sinphi,cosphi;

	phi = DEG_TO_RADS * ang;
	cosphi = cos(phi);
	sinphi = sin(phi);
	lenstr = digvtextlen(txt,height,ang,prop);

/* Draw a cross:
    digline(bun,
	x-0.5*(len*cosphi+height*sinphi),y-0.5*(len*sinphi-height*cosphi),
	x+0.5*(len*cosphi-height*sinphi),y+0.5*(len*sinphi+height*cosphi));
    digline(bun,x,y,x-height*sinphi,y+height*cosphi);
*/
	if (lenstr > len) {
		height *= len/lenstr;
		lenstr = len;
	}
	lenstr *= 0.5;
	digvtext(bun,x-lenstr*cosphi,y-lenstr*sinphi,txt,height,ang,prop);
	digflush();
}

#ifdef EMO
#include <stdio.h>

main()
{

	digstart('\0',NULL,0);
	digscale(1.0,3.0,0);
	digbox(20,0.3,0.3,0.7,0.6);
	digboxtext(20,0.5,0.3,0.4,0.3,0.0,"A",1);
	digboxtext(20,0.5,0.3,0.4,0.3,0.0,"ABCDEFGHIJKLMNOPQRSTUVWXYZ",1);

	digline(20,0.2,0.8,0.3,0.7);
	digline(20,0.3,0.7,0.8,1.2);
	digline(20,0.8,1.2,0.7,1.3);
	digline(20,0.7,1.3,0.2,0.8);
	digboxtext(20,0.55,0.95,0.707,0.1414,45.0,"A",1);
	digboxtext(20,0.55,0.95,0.707,0.1414,45.0,"ABCDEFGHIJKLMNOPQRSTUVWXYZ",1);

	digbox(20,0.1,1.0,0.2,2.5);
	digboxtext(20,0.2,1.75,1.5,0.1,90.0,"A",1);
	digboxtext(20,0.2,1.75,1.5,0.1,90.0,"ABCDEFGHIJKLMNOPQRSTUVWXYZ",1);
	digquit(15);
}

#endif
