/* gfont - load/change vector fonts */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "sfs.h"
#include "dig.h"
#include "digdata.h"

/* to have a memory resident default font, include Dfont.h here */
#include "dfont.h"

/* manifest constants */
#define NFONTS 4	/* number of cached fonts */
#define NAMELEN 15	/* max length of font name */

#define VFHEIGHT 21	/* height of a capital letter	*/
#define VFYOFF   32	/* added to y coordinates to make positive	*/
#define VFXOFF   16	/* likewise for x	*/
#define VFBASE	  9	/* bottom of a capital letter	*/

#ifdef __STDC__
int get2num(FILE *ip,int *v1,int *v2);
#endif

/* Read/Select a vector font */
void	digfont(name)
char 	*name;
{
	/* font cache */
	static char	names[NFONTS][NAMELEN];
	static char	*fontvecs[NFONTS];
	static short	*fontinds[NFONTS];
	static short	ifont = 0;
#ifndef DFONT
	static char 	defname[] = "roman";	/* default font	*/
#endif
	int 		len,i;
	int 		ichar,xmin,ix,iy,orx;
	short 		*newind;
	short 		maxwidth;
	char 		*newvec;
	char 		fullname[NAMELEN+80];
	FILE 		*fp,*fopen();

	/* choose default font */
	if (!*name) {
#ifdef DFONT
		/* font already in memory */
		digdata.fontvec = Dfvec;
		digdata.fontind = Dfind;
		return;
#else
		/* load default font */
		name = defname;
#endif
	}

	/* check if font in cache */
	for (i=NFONTS-1; i>=0; i--) {
		if(!strcmp(name,names[i])) break;
	}

	if (i>=0) {
		/* found it */
		digdata.fontvec = fontvecs[i];
		digdata.fontind = fontinds[i];
		return;
	}
	else {
		/* read in a new font */
		sprintf(fullname,"%s/data/font/%s.vf",sfsbase(),name);
		if ((fp = fopen(fullname,"r")) == NULL) {
			fprintf(stderr,"digfont: Cannot open %s\n",fullname);
			exit(1);
		}

		/* Pass 1 - get amount of memory required */
		i = 1;		/* allow one byte for max length */
		while (get2num(fp,&ichar,&iy) == 1) {
			i--;	/* length only takes one byte */
			do {
				if (get2num(fp,&ix,&iy) != 2) {
					fprintf(stderr,"digfont: Error reading %s\n",fullname);
					exit(1);
				}
				if (ix > -64) i += 2;	/* count the genuine vectors	*/
			} while (iy > -64);
		}

		/* allocate memory */
		newvec = (char *) malloc(i*sizeof(char));
		newind = (short *) malloc(256*sizeof(short));
		if ((newvec == NULL) || (newind == NULL)) {
			fprintf(stderr,"digfont: Cannot allocate memory for %s\n",name);
		}
		if (digdata.fontvec == fontvecs[ifont]) ifont = (ifont+1) % NFONTS;
		if (fontvecs[ifont]) {			/* zap it if already filled	*/
			free(fontvecs[ifont]);
			free(fontinds[ifont]);
			names[ifont][0] = '\0';
		}

		digdata.fontvec = fontvecs[ifont] = newvec;
		digdata.fontind = fontinds[ifont] = newind;
		strcpy(names[ifont],name);

		/* Pass 2 - read in font for real */
		rewind(fp);
		for (i=255; i>=0; i--) digdata.fontind[i] = 0;	/* mark unused ones	*/
		maxwidth = 0;
		newvec++;	/* skip over max length	*/
		while (get2num(fp,&ichar,&iy) == 1) {
			digdata.fontind[ichar]=newvec-digdata.fontvec;
			get2num(fp,&xmin,&iy);
			*newvec++ = len = iy-xmin;			/* character length	*/
			if (len > maxwidth) maxwidth = len;
			orx = 128;

			do {
				get2num(fp,&ix,&iy);
				if (ix > -64) {
					*newvec++ = (ix - xmin + VFXOFF) | orx;
					*newvec++ = VFYOFF + VFBASE  - iy;
					orx = 0;
				}
				else orx = 128;			/* mark next as new line	*/
			} while (iy > -64);
			newvec[-1] |= 128;			/* flag the last vector (or length) */
		}
		*digdata.fontvec = maxwidth;
		fclose(fp);
		return;
	}
}

#include <ctype.h>

int get2num(ip,v1,v2)
FILE	*ip;
int	*v1,*v2;
{
	register int	c,neg=0;

	while (((c=getc(ip)) != EOF) && isspace(c)) /* skip */;
	if (c==EOF) return(EOF);
	if (!isdigit(c) && (c!='-')) return(0);
	if (c=='-') {
		neg++;
		if ((c=getc(ip))==EOF) return(EOF);
		if (!isdigit(c)) return(0);
	}
	*v1 = c - '0';					/* 1st digit */
	if ((c=getc(ip))==EOF) return(EOF);
	if (isdigit(c)) {
		*v1 = 10 * *v1 + c - '0';		/* 2nd digit */
		if ((c=getc(ip))==EOF) return(EOF);
		if (isdigit(c))
			*v1 = 10 * *v1 + c - '0';	/* 3rd digit */
		else
			ungetc(c,ip);
	}
	else
		ungetc(c,ip);
	if (neg) *v1 = - *v1;
	neg=0;
	/* second number */
	while (((c=getc(ip)) != EOF) && isspace(c)) /* skip */;
	if (c==EOF) return(EOF);
	if (c==':') return(1);
	if (!isdigit(c) && (c!='-')) return(0);
	if (c=='-') {
		neg++;
		if ((c=getc(ip))==EOF) return(EOF);
		if (!isdigit(c)) return(0);
	}
	*v2 = c - '0';					/* 1st digit */
	if ((c=getc(ip))==EOF) return(EOF);
	if (isdigit(c)) {
		*v2 = 10 * *v2 + c - '0';		/* 2nd digit */
		if ((c=getc(ip))==EOF) return(EOF);
		if (isdigit(c)) {
			*v2 = 10 * *v2 + c - '0';	/* 3rd digit */
			if ((c=getc(ip))==EOF) return(EOF);
		}
	}
	if (neg) *v2 = - *v2;
	if (c==':') return(2);
	return(0);
}

#ifdef EMO
main()
{
	digfont("gothen");
	digfont("gothgr");
	digfont("gothit");
	digfont("triplro");
	digfont("triplit");
}
#endif
