/* ggscale -- draw a grey-scale picture */

/* M.A.Huckvale - November 1987 */

#include <stdio.h>
#include <malloc.h>
#include "SFSCONFG.h"
#include "dig.h"
#include "digdata.h"
#include "digtable.h"

/* grey scale routine */
#ifdef __STDC__
void   diggreyscale(int   bundle,float  xl,float   yb,float  xr,float  yt,char  *buff,int  length,int  height,int  depth)
#else
void diggreyscale(bundle,xl,yb,xr,yt,buff,length,height,depth)
int 	bundle;			/* bundle number */
float	xl,yb,xr,yt;		/* co-ords of box */
char	*buff;			/* pixel buffer */
int	length;			/* # frames of pixel data */
int	height;			/* # pixels per frame */
int	depth;			/* # grey levels supplied (0..depth) */
#endif
{
	diggreyscalep(bundle,xpix(xl),ypix(yb),xpix(xr),ypix(yt),
				buff,length,height,depth);
}

/* pixel buffer */
unsigned char	pbuff[1024];

void diggreyscalep(bundle,xl,yb,xr,yt,buff,length,height,depth)
int 	bundle;			/* bundle number */
int	xl,yb,xr,yt;		/* co-ords of box */
char	*buff;			/* pixel buffer */
int	length;			/* # frames of pixel data */
int	height;			/* # pixels per frame */
int	depth;			/* # grey levels supplied (0..depth) */
{
	register int 	i,j;
	register unsigned char	*p;
	char		*pix;
	char		*greymap;
	int		*posmap;
	int		plength,pheight;
	float		lscale,hscale,dscale;

	/* flush out any existing lines */
	digflush();

	/* check device can do greyscale */
	if (!digtable[digdata.select].greyscale)
		return;

	/* move in by one pixel */
	xl++;
	yb++;
	xr--;
	yt--;
	
	/* work out scaling */
	plength = (xr - xl + 1)/digdata.digdev.greypixwidth;
	pheight = (yt - yb + 1)/digdata.digdev.greypixheight;
	lscale = ((float)length)/plength;
	hscale = ((float)height)/pheight;
	dscale = ((float)digdata.digdev.greylevels)/depth;

	/* make quicky look-ups */
	if ((greymap=(char *)malloc(depth+1))==NULL)
		error("could not get memory buffer");
	for (i=0;i<=depth;i++)
		greymap[i]=(int)(0.5+(float)i*dscale);
	if ((posmap=(int *)calloc(pheight,sizeof(int)))==NULL)
		error("could not get memory buffer");
	for (i=0;i<pheight;i++)
		posmap[i]=(int)((float)i*hscale);
		
	/* process vertical slices */
	for (i=0;i<plength;i++) {

		/* calculate source address */
		pix = &buff[((int)(lscale*i))*height];
		
		/* sample into output buffer */
		p = pbuff;
		for (j=pheight-1;j>=0;j--,p++)
			*p = greymap[*(pix + posmap[j])];

		/* call routine to display slice */
		(*digtable[digdata.select].greyscale)(xl,yb,pheight,pbuff);

		/* move to next slice */
		xl += digdata.digdev.greypixwidth;
	}
	
	free(posmap);
	free(greymap);
}

#ifdef EMO
main()
{
	static char	buff[32][16]={  
					9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
					9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
				 	9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,
				 	9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,
					9,0,8,8,8,8,8,8,8,8,8,8,8,8,0,9,
					9,0,8,8,8,8,8,8,8,8,8,8,8,8,0,9,
					9,0,8,1,1,1,1,1,1,1,1,1,1,8,0,9,
					9,0,8,1,1,1,1,1,1,1,1,1,1,8,0,9,
					9,0,8,1,7,7,7,7,7,7,7,7,1,8,0,9,
					9,0,8,1,7,7,7,7,7,7,7,7,1,8,0,9,
					9,0,8,1,7,2,2,2,2,2,2,7,1,8,0,9,
					9,0,8,1,7,2,2,2,2,2,2,7,1,8,0,9,
					9,0,8,1,7,2,6,6,6,6,2,7,1,8,0,9,
					9,0,8,1,7,2,6,6,6,6,2,7,1,8,0,9,
					9,0,8,1,7,2,6,3,3,6,2,7,1,8,0,9,
					9,0,8,1,7,2,6,3,3,6,2,7,1,8,0,9,
					9,0,8,1,7,2,6,3,3,6,2,7,1,8,0,9,
					9,0,8,1,7,2,6,3,3,6,2,7,1,8,0,9,
					9,0,8,1,7,2,6,6,6,6,2,7,1,8,0,9,
					9,0,8,1,7,2,6,6,6,6,2,7,1,8,0,9,
					9,0,8,1,7,2,2,2,2,2,2,7,1,8,0,9,
					9,0,8,1,7,2,2,2,2,2,2,7,1,8,0,9,
					9,0,8,1,7,7,7,7,7,7,7,7,1,8,0,9,
					9,0,8,1,7,7,7,7,7,7,7,7,1,8,0,9,
					9,0,8,1,1,1,1,1,1,1,1,1,1,8,0,9,
					9,0,8,1,1,1,1,1,1,1,1,1,1,8,0,9,
					9,0,8,8,8,8,8,8,8,8,8,8,8,8,0,9,
					9,0,8,8,8,8,8,8,8,8,8,8,8,8,0,9,
				 	9,0,0,0,0,0,0,9,9,0,0,0,9,9,0,9,
				 	9,0,0,0,0,0,0,9,9,0,0,0,9,9,0,9,
					9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
					9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9
				     };

	digstart('\0',NULL,1);
	digscale(8.0,8.0,1);
	digline(20,0.0,0.0,8.0,0.0);
	digline(20,0.0,0.0,0.0,8.0);
	digorigin(3.5,3.5);
	digbox(20,0.0,0.0,2.0,1.0);
	diggreyscale(20,0.0,0.0,2.0,1.0,(char *)buff,32,16,10);
	digorigin(-2.0,-2.0);
	digbox(20,0.0,0.0,1.0,2.0);
	diggreyscale(20,0.0,0.0,1.0,2.0,(char *)buff,32,16,10);
	digorigin(4.0,4.0);
	digbox(20,0.0,0.0,2.0,2.0);
	diggreyscale(20,0.0,0.0,2.0,2.0,(char *)buff,32,16,20);
	digend();
}
#endif
