/* glmode -- set line drawing mode */

#include <stdio.h>
#include "SFSCONFG.h"
#include "dig.h"
#include "digdata.h"
#include "digtable.h"

/* set line drawing mode to 'replace' or 'invert' */
int 	diglinemode(mode)
int	mode;			/* 0=replace, 1=xor */
{
	int	retcode;
	
	/* flush any existing lines */
	digflush();

	/* check device has raster modes */
	if (digtable[digdata.select].rasterop)
		/* ok - call it */
		retcode = (*digtable[digdata.select].rasterop)(mode);
	else if (mode)
		/* non-zero modes not supported */
		retcode = -1;
	else
		/* zero mode always supported */
		retcode = 0;
	return(retcode);
}

#ifdef EMO
main()
{
	digstart('\0',NULL,1);
	digscale(5.0,4.0,1);
	digclearscreen();

	digfont("triplro");

	if (diglinemode(1) >= 0) {
		digboxtext(1,2.5,1.0,5.0,3.0,0.0,"HELLO",1);
		sleep(1);
		digboxtext(1,2.5,1.0,5.0,3.0,0.0,"GOODBYE",1);
		sleep(1);
		digboxtext(1,2.5,1.0,5.0,3.0,0.0,"HELLO",1);
	}
	diglinemode(0);

	digtext(20,1.0,3.5,"Normal");
	digtext(20,2.0,3.5,"Inverted");
	diglinemode(1);
	digfillbox(0,2.0,3.5,
			2.0+8*digdata.chwidth/digdata.xscale,
			3.5+digdata.chheight/digdata.yscale);
	diglinemode(0);
	digquit(15);
}
#endif
