/* gscale -- set up scale factors for graphics */

#include <stdio.h>
#include <math.h>
#include "SFSCONFG.h"
#include "dig.h"
#include "digdata.h"
#include "digtable.h"

#ifdef __STDC__
void   digscale(float  x,float  y,int  equal)
#else
void	digscale(x,y,equal)
float 	x,y;			/* screen size in real units */
int 	equal;			/* 1 in order to force equal scales */
#endif
{
	float rxscale,ryscale;

	/* check dimensions */
	(*digtable[digdata.select].params)(digdata.subtype,&digdata.digdev);
	
	/* move commonly used details up to old positions */
	digdata.nhoriz        = digdata.digdev.nhoriz;
	digdata.nvert         = digdata.digdev.nvert;
	digdata.aspect        = digdata.digdev.aspect;
	digdata.chwidth       = digdata.digdev.chwidth;
	digdata.chheight      = digdata.digdev.chheight;

	rxscale = x/(digdata.nhoriz - 1);
	ryscale = y/(digdata.nvert - 1);
	if (equal) {
		if (rxscale*digdata.aspect > ryscale) {
			ryscale = rxscale * digdata.aspect;
		}
		else 
			rxscale = ryscale/digdata.aspect;
	}
	digdata.xscale = 1.0/rxscale;
	digdata.yscale = 1.0/ryscale;
	digdata.horiz = rxscale * (digdata.nhoriz - 1);
	digdata.vert = ryscale * (digdata.nvert - 1);
	digdata.xorig = 0.5*digdata.xscale*(digdata.horiz-x) /* + 0.5 */;
	digdata.yorig = 0.5*digdata.yscale*(digdata.vert-y) /* + 0.5 */;
	digdata.clipxmin   = digdata.clipymin = 0;
	digdata.clipxmax   = digdata.nhoriz-1;
	digdata.clipymax   = digdata.nvert-1;
}

#ifdef EMO
main()
{
	digstart('\0',NULL,0) ;
	digscale (4.0,4.0,0);
	digorigin(2.0,2.0);

	digline(20,-1.0,-1.0,-1.0,1.0);
	digline(20,-1.0,1.0,1.0,1.0);
	digline(20,1.0,1.0,1.0,-1.0);
	digline(20,1.0,-1.0,-1.0,-1.0);

	digwait();
	digclearscreen();
	
	digscale (4.0,4.0,1);
	digorigin(2.0,2.0);

	digline(20,-1.0,-1.0,-1.0,1.0);
	digline(20,-1.0,1.0,1.0,1.0);
	digline(20,1.0,1.0,1.0,-1.0);
	digline(20,1.0,-1.0,-1.0,-1.0);

	digquit(15);
}
#endif
