/* gvtext -- draw vector text */

#include <stdio.h>
#include <math.h>
#include "SFSCONFG.h"
#include "dig.h"
#include "digdata.h"

/* manifest constants */
#define VFHEIGHT 21	/* height of a capital letter	*/
#define VFYOFF   32	/* added to y coordinates to make positive	*/
#define VFXOFF   16	/* likewise for x	*/
#define VFBASE	  9	/* bottom of a capital letter	*/

/*
The characters are always drawn with correct proportions
regardless of display scaling. The height is what you would
expect for angle equal to a multiple of 90 and varies smoothly
in between.
*/
#ifdef __STDC__
void   digvtext(int  bundle,float  xstr,float  ystr,char  *word,float  height,float  angle,int  prop)
#else
void	digvtext (bundle,xstr,ystr,word,height,angle,prop)
float 	xstr,ystr,height,angle;
int 	bundle,prop;
char 	*word;
#endif
{
	float	cosblock,sinblock,cosphi,sinphi ;
	float	xcos,xsin,ycos,ysin ;
	float	xold,yold,xpoint,ypoint,xnew,ynew,realy ;
	float	xyscale;		/* could be in digdata */

	int letter;
	int xoff,len,ix,iy,jx,jy;
	short maxwidth;

	char *pc;

	/* load default font if required */
	if (!digdata.fontind) digfont("");
	maxwidth = *digdata.fontvec;

	/* calculate drawing constants */
	cosphi = cos (DEG_TO_RADS * angle) ;
	sinphi = sin (DEG_TO_RADS * angle) ;
	xyscale = digdata.aspect * digdata.yscale / digdata.xscale;

	ycos = cosphi/xyscale;
	xsin = sinphi*xyscale;
	realy = height / (VFHEIGHT *  (xsin*sinphi + ycos*cosphi));
	ycos *= realy;
	xsin *= realy;
	xcos = cosphi * realy;
	ysin = sinphi * realy;
	cosblock = maxwidth * xcos;
	sinblock = maxwidth * ysin;
	xpoint = xstr;
	ypoint = ystr;
	xoff = 0;
	xold = yold = 0;

	while ((letter = ((*word++) & 0377))) {

		pc = digdata.fontvec + digdata.fontind[letter];
		if (pc > digdata.fontvec) {	/* ignore undefined chars */
			len = *pc & 0177;
			if (!prop) xoff = (maxwidth-len)/2;
			if (*pc++ > 0) {	/* check for no plot lines */
				do {
					jx = ((ix = *pc++) & 0177) + xoff - VFXOFF;
					jy = ((iy = *pc++) & 0177) - VFYOFF;
					xnew = xpoint + ( xcos * jx ) - ( xsin * jy ) ;
					ynew = ypoint + ( ycos * jy ) + ( ysin * jx ) ;
					if (ix>=0) digline (bundle,xold,yold,xnew,ynew) ;
					xold = xnew ;
					yold = ynew ;
				} while (iy>=0);
			}
			if (prop) {
				xpoint += xcos*len;
				ypoint += ysin*len;
			}
			else {
				xpoint = xpoint + cosblock ;
				ypoint = ypoint + sinblock ;
			}
		}
	}
}

#ifdef EMO
#define PI 3.14159265

main ()
{

	char ch[2];
	float phi;
	int i;

	ch[1] = '\0';

	digstart('\0',NULL,0) ;
	digscale(6.0,2.6,0);
	digorigin(1.5,1.3);
	for (i=0; i<26; i++) {
		phi = i * (PI * 2.0 / 26.0);
		*ch = i + 'A';
		digvtext(20,cos(phi),sin(phi),ch,0.20,phi*(180.0/PI),0);
	}

	digfont("triplro");

	digvtext(20,1.5,0.5,"Fixed",0.1,0.0,0);
	digvtext(20,1.5,-0.6,"Proportional",0.1,0.0,1);

	digquit(15);
}
#endif
