/* gwait() - ring bell and wait for a carriage return */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include "dig.h"
#include "digdata.h"
#include "digtable.h"

#ifndef DOS
int diggetkeypress()
{
	struct termio	oldmode,newmode;
	int	tty;
	char	c;

	if (digdata.tty == -1) {
		if ((tty = open ("/dev/tty",O_RDONLY)) >= 0) {
			ioctl(tty,TCGETA,&oldmode);
			newmode = oldmode;
			newmode.c_lflag = newmode.c_lflag & ~ICANON;
			newmode.c_lflag = newmode.c_lflag & ~ECHO;
			newmode.c_cc[4]=1;		/* 1 character burst */
			newmode.c_cc[5]=0;		/* wait */
			ioctl(tty,TCSETA,&newmode);

			read(tty,&c,1);
	
			ioctl(tty,TCSETA,&oldmode);
			close(tty);
		}
	}
	else
		read(digdata.tty,&c,1);
	return(c);
}
#endif

int digwait()
{
#ifndef DOS
 	int	tgrp;
#endif
	char	c;

	/* flush waiting lines */
	digflush();
	
	/* see if special routine */
	if (digtable[digdata.select].pause)
		return((digtable[digdata.select].pause)());

	/* no, do it ourselves then */
#ifdef DOS
	putchar(BELL);
	c=getchar();
	return(c);
#else

#if defined(MASSCOMP)
	if (ioctl(1,TIOCGPGRP,&tgrp) != 0) 
#else
	if ((tgrp=tcgetpgrp(1)) < 0)
#endif
		return(0);		/* not a terminal */
#if defined(LINUX) || defined(SVR4)
	else if (tgrp != getpgrp()) 
#else
	else if (tgrp != getpgrp(0)) 
#endif
		return(0);		/* not foreground */
	else {
		/* should flush input at this stage */
		c=BELL;
		write(1,&c,1);

		/* otherwise hang on TTY */
		return(diggetkeypress());
	}
#endif
}


#ifdef EMO
main()
{
	int	code;    

	digstart('\0',NULL,1);
	do {
		digscale (4.0,4.0,1);
		digorigin(2.0,2.0);
		digclearscreen();

		digbox(20,-1.0,-1.0,1.0,1.0);
		digline(21,-1.0,-1.0,1.0,1.0);
		digline(21,-1.0,1.0,1.0,-1.0);
		code=digwait();
		digclearscreen();
		printf("digwait returned code %d\n",code);

	} while (code==DIG_REDRAW);
	digend();

}
#endif
