/* metafile -- DIG routines for Graphics Metafile format */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <fcntl.h>
#ifdef DOS
#include <io.h>
#endif
#include "dig.h"
#include "digdata.h"

/* 'hardware' text size */
#define METATEXT 40

/* return Metafile parameters */
int meta_params(subtype,digdev)
int	subtype;
struct digdevice *digdev;
{
	digdev->nhoriz = 18000;
	digdev->nvert = 13500;
	digdev->aspect = 1.0;
	digdev->chwidth = 5*METATEXT;
	digdev->chheight = 8*METATEXT;
	digdev->greylevels = 0;
	digdev->greypixwidth = 1;
	digdev->greypixheight = 1;
	return(0);
}

/* open output file */
int meta_outfile(fp)
FILE	**fp;
{
#ifdef DOS
	if ((*fp=fopen("metafile","wb"))==NULL) {
		*fp = stdout;
		setmode(1,O_BINARY);
#else
	if ((*fp=fopen("metafile","w"))==NULL) {
		*fp = stdout;
#endif
	}
	else
		fprintf(stderr,"(dig) output to 'metafile'\n");
	return(0);
}

/* open graphics */
int meta_open()
{
	return(0);
}

/* interrupt graphics */
int meta_inter()
{
	fflush(digdata.outfile);
	return(0);
}

/* close graphics */
int meta_close()
{
	digflush();
	fclose(digdata.outfile);
	return(0);
}

/* clear screen */
int meta_clear()
{
	short	buff[2];
	
	buff[0]= (15 << 12) + 2;
	buff[1]= ('P' << 8);
	fwrite(buff,2,2,digdata.outfile);
	return(0);
}

int meta_polyline(bundle,buff,len)
int	bundle;
short	*buff;
int	len;
{
	short	hdr;

	/* write a header to output */
	hdr = len+2;
	fwrite(&hdr,sizeof(short),1,digdata.outfile);

	/* write chain to output */
	fwrite(buff,sizeof(short),len,digdata.outfile);

	/* write colour */
	hdr = bundle << 8;
	fwrite(&hdr,sizeof(short),1,digdata.outfile);

	fflush(digdata.outfile);
	return(0);
}

/* draw 'hardware' text */
int meta_text(bundle,x,y,str)
int	bundle;
int	x,y;
char	*str;
{
	short	buffer[5];
	int count,odd;

	count = strlen(str);
	odd = count % 2;
	count = (count + 1 ) / 2 + 5;
	buffer[0] = (2 << 12) | count;
	buffer [1] = x + 5*METATEXT/2;
	buffer [2] = y + 5*METATEXT;
	fwrite(buffer,sizeof(short),3,digdata.outfile);
	fputc(bundle,digdata.outfile);
	fputc(0,digdata.outfile);
	fputc(METATEXT,digdata.outfile);
	fputc(0,digdata.outfile);
	while (*str) fputc(*str++,digdata.outfile);
	if (odd) fputc('\0',digdata.outfile);
	return(0);
}

/* draw a filled rectangle */
int meta_fillrect(bundle,x1,y1,x2,y2)
int	bundle;
int	x1,y1,x2,y2;
{
	short int buffer[8];

	buffer [0] = ( 14 << 12 ) + 8;
#if SFSMACHINE==0
	buffer [1] = ( 9 << 8 ) + bundle;
#else
	buffer [1] = (bundle << 8) + 9;
#endif
	buffer [2] = 1;
	buffer [3] = 0;
	buffer [4] = x1;
	buffer [5] = y1;
	buffer [6] = x2;
	buffer [7] = y2;
	fwrite (buffer,2,8,digdata.outfile);
	return(0);
}

/* draw circle */
int meta_circle(bundle,xc,yc,r)
int	bundle;
int	xc,yc;
int	r;
{
	short	buf[8];

	buf[0] = (3 << 12) | 8;
	buf[1] = xc-r;
	buf[2] = yc;
	buf[3] = xc+r;
	buf[4] = yc;
	buf[5] = xc-r;
	buf[6] = yc;
	buf[7] = bundle << 8;
	fwrite(buf,2,8,digdata.outfile);
	return(0);
}

int meta_fcircle(bundle,xc,yc,r)
int	bundle;
int	xc,yc;
int	r;
{
	short	buf[9];

	buf[0] = (14 << 12) | 9;
	buf[1] = (10 << 8) | bundle;
	buf[2] = 1;
	buf[3] = 0;
	buf[4] = r;
	buf[5] = 0;
	buf[6] = 360;
	buf[7] = xc;
	buf[8] = yc;
	fwrite(buf,2,9,digdata.outfile);
	return(0);
}	

/* draw an arc - NON STANDARD CALL */
int meta_arc(bundle,x1,y1,x2,y2,x3,y3)
int	bundle;
int	x1,y1;
int	x2,y2;
int	x3,y3;
{
	short	buf[8];

	buf[0] = (3 << 12) | 8;
	buf[1] = x1;
	buf[2] = y1;
	buf[3] = x2;
	buf[4] = y2;
	buf[5] = x3;
	buf[6] = y3;
	fwrite(buf,2,7,digdata.outfile);
	fputc(bundle,digdata.outfile);
	fputc(0,digdata.outfile);
	return(0);
}
